/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import java.util.Vector;

public class Not
extends Expression {
    Expression term1;

    public Not(Expression expression, ControlGraph controlGraph) {
        super(new String("!(" + expression.toString() + ")"), controlGraph);
        this.term1 = expression;
    }

    @Override
    public boolean evaluateBool(Buffer buffer) {
        if (this.term1.containsLoad() != -1) {
            throw new InternalError("Not can not contain a load statement");
        }
        return !this.term1.evaluateBool(buffer);
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return this.evaluateBool(buffer);
    }

    @Override
    public int evaluateInt(Buffer buffer) {
        throw new InternalError("Not is not integer");
    }

    @Override
    public int containsLoad() {
        return this.term1.containsLoad();
    }

    @Override
    public boolean containsLoadAt(int n) {
        return this.term1.containsLoadAt(n);
    }

    @Override
    public Object clone() {
        Not not = (Not)super.clone();
        not.term1 = (Expression)this.term1.clone();
        return not;
    }

    @Override
    public String evaluatedString() {
        return new String("!(" + this.term1.evaluatedString() + ")");
    }

    @Override
    public int type() {
        return 21;
    }

    @Override
    public void apply(Buffer buffer) {
        throw new InternalError("Not cannot be applied");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Not)) {
            return false;
        }
        Not not = (Not)object;
        return this.term1.equals(not.term1);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return this.evaluateBool(vector);
    }

    @Override
    public int evaluateInt(Vector<Buffer> vector) {
        throw new InternalError("Not cannot be evaluated integer");
    }

    @Override
    public boolean evaluateBool(Vector<Buffer> vector) {
        if (this.term1.containsLoad() != -1) {
            throw new InternalError("Not can not contain a load statement");
        }
        return !this.term1.evaluateBool(vector);
    }

    @Override
    public int hashCode() {
        return this.term1.hashCode();
    }

    @Override
    public boolean bufferModified() {
        return this.term1.bufferModified();
    }
}

