/*
 * Decompiled with CFR 0.152.
 */
package controlgraph.actions;

import buffer.Buffer;
import buffer.BufferStoreContent;
import controlgraph.Action;
import controlgraph.ControlGraph;
import controlgraph.Expression;
import controlgraph.Identifier;
import controlgraph.Transition;
import controlgraph.Variable;
import java.util.Vector;

public class ST
extends Action {
    private Identifier identifier;
    private Variable lV = null;
    private Expression expression;
    private Transition t = null;

    public ST(Identifier identifier, Expression expression, ControlGraph controlGraph) {
        super(new String("Store(" + identifier.toString() + "," + expression.toString() + ")"), controlGraph);
        this.identifier = identifier;
        this.expression = expression;
    }

    public void setTransition(Transition transition) {
        this.t = transition;
    }

    public Transition getTransition() {
        return this.t;
    }

    public Variable getGlobalVariable() {
        if (this.lV != null) {
            return this.lV;
        }
        throw new InternalError("Variable must be initialized before");
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setLV(Variable variable) {
        this.lV = variable;
    }

    public void setLV(int n) {
        this.lV = this.identifier.getVariable(n);
    }

    public void setLV(int[] nArray) {
        this.lV = this.identifier.getVariable(nArray);
    }

    public Action getExpression() {
        return this.expression;
    }

    @Override
    public void apply(Buffer buffer) {
        this.lV = this.cG.getVariable(this.identifier);
        BufferStoreContent bufferStoreContent = this.lV.isBool() ? new BufferStoreContent(this.expression.evaluateBool(buffer), this.lV.getName(), this.lV.getId(), this.t) : new BufferStoreContent(this.expression.evaluateInt(buffer), this.lV.getName(), this.lV.getId(), this.t);
        buffer.addStore(bufferStoreContent);
    }

    @Override
    public int containsLoad() {
        return -1;
    }

    @Override
    public boolean containsLoadAt(int n) {
        return false;
    }

    public BufferStoreContent getStoreContent(Buffer buffer) {
        this.lV = this.cG.getVariable(this.identifier);
        if (this.lV.isBool()) {
            return new BufferStoreContent(this.expression.evaluateBool(buffer), this.lV.getName(), this.lV.getId(), this.t);
        }
        return new BufferStoreContent(this.expression.evaluateInt(buffer), this.lV.getName(), this.lV.getId(), this.t);
    }

    @Override
    public Object clone() {
        ST sT = (ST)super.clone();
        sT.identifier = (Identifier)this.identifier.clone();
        if (this.lV != null) {
            sT.lV = (Variable)this.lV.clone();
        }
        sT.expression = (Expression)this.expression.clone();
        return sT;
    }

    @Override
    public String evaluatedString() {
        return new String("Store(" + this.lV.toString() + "," + this.expression.evaluatedString() + ")");
    }

    public int evaluateInt(Buffer buffer) {
        throw new InternalError("ST cannot be evaluated int");
    }

    public boolean evaluateBool(Buffer buffer) {
        throw new InternalError("ST cannot be evaluated bool");
    }

    @Override
    public boolean isTrue(Buffer buffer) {
        return true;
    }

    @Override
    public int type() {
        return 0;
    }

    public int getVarId() {
        this.lV = this.cG.getVariable(this.identifier);
        return this.lV.getId();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ST)) {
            return false;
        }
        ST sT = (ST)object;
        if (!this.identifier.equals(sT.identifier)) {
            return false;
        }
        return this.expression.equals(sT.expression);
    }

    @Override
    public boolean isTrue(Vector<Buffer> vector) {
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.lV != null ? this.lV.getId() : this.identifier.getName().hashCode();
        n = n * 1103515245 + 12345 + this.expression.hashCode();
        return n;
    }

    @Override
    public boolean bufferModified() {
        return false;
    }
}

