/*
 * Decompiled with CFR 0.152.
 */
package modelchecker;

import controlgraph.ControlGraph;
import controlgraph.Node;
import controlgraph.Variable;
import java.util.Arrays;
import java.util.HashSet;
import modelchecker.MemoryVariable;

public class Process
implements Cloneable {
    private MemoryVariable[] localVars;
    private final int nbProcess;
    private int controlLocation = 0;
    private ControlGraph cG;
    private HashSet<Integer> loadedVarsIds;
    private final int m = 1103515245;
    private final int b = 12345;

    public Process(int n, int n2, ControlGraph controlGraph) {
        this.nbProcess = n;
        this.localVars = new MemoryVariable[n2];
        this.cG = controlGraph;
        this.loadedVarsIds = new HashSet();
    }

    public void setLoadedVars(HashSet<MemoryVariable> hashSet) {
        if (this.loadedVarsIds == null) {
            this.loadedVarsIds = new HashSet();
        }
        for (MemoryVariable memoryVariable : hashSet) {
            this.loadedVarsIds.add(new Integer(memoryVariable.getVarId()));
        }
    }

    public void setLocalVars(MemoryVariable[] memoryVariableArray) {
        if (this.localVars.length != memoryVariableArray.length) {
            throw new InternalError("size error in local memory");
        }
        for (int i = 0; i < this.localVars.length; ++i) {
            this.localVars[i] = (MemoryVariable)memoryVariableArray[i].clone();
        }
    }

    public int getProcessNb() {
        return this.nbProcess;
    }

    public int getControlLocation() {
        return this.controlLocation;
    }

    public HashSet<Integer> getLoadedVarIds() {
        return this.loadedVarsIds;
    }

    public void setLocalVar(int n, int n2) {
        if (n >= this.localVars.length) {
            throw new InternalError("index error in local variables");
        }
        this.localVars[n].setValue(n2);
    }

    public void setLocalVar(int n, boolean bl) {
        if (n >= this.localVars.length) {
            throw new InternalError("index error in local variables");
        }
        this.localVars[n].setValue(bl);
    }

    public Object clone() {
        Process process;
        try {
            process = (Process)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("At least one subclass of Processdoes not implement Cloneable");
        }
        process.localVars = new MemoryVariable[this.localVars.length];
        for (int i = 0; i < this.localVars.length; ++i) {
            process.localVars[i] = (MemoryVariable)this.localVars[i].clone();
        }
        process.loadedVarsIds = new HashSet();
        for (Integer n : this.loadedVarsIds) {
            process.loadedVarsIds.add(new Integer(n));
        }
        return process;
    }

    public int hashCode() {
        int n = this.nbProcess;
        n = n * 1103515245 + 12345 + Arrays.hashCode(this.localVars);
        n = n * 1103515245 + 12345 + this.controlLocation;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Process)) {
            return false;
        }
        Process process = (Process)object;
        if (this.nbProcess != process.nbProcess) {
            return false;
        }
        if (this.controlLocation != process.controlLocation) {
            return false;
        }
        for (int i = 0; i < this.localVars.length; ++i) {
            if (this.localVars[i].equals(process.localVars[i])) continue;
            return false;
        }
        return true;
    }

    public void pushLocalMem2ControlGraphMem() {
        for (int i = 0; i < this.localVars.length; ++i) {
            if (this.localVars[i].isBool()) {
                this.cG.setLocalVar(i, this.localVars[i].boolValue());
                continue;
            }
            this.cG.setLocalVar(i, this.localVars[i].intValue());
        }
    }

    public void popLocalMemFromControlGraphMem() {
        for (int i = 0; i < this.localVars.length; ++i) {
            Variable variable = this.cG.getLocalVariableAt(i);
            if (!this.localVars[i].isBool()) {
                this.localVars[i].setValue(variable.getIntValue());
                continue;
            }
            this.localVars[i].setValue(variable.getBoolValue());
        }
    }

    public Node getCurrentNode() {
        return this.cG.getControlLocationNode(this.controlLocation);
    }

    public void setControlLocation(int n) {
        this.controlLocation = n;
    }
}

