/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.pso;

import buffer.Buffer;
import buffer.BufferContent;
import controlgraph.ControlGraphs;
import controlgraph.Transition;
import exceptions.MfenceException;
import exceptions.NoRelaxationException;
import exceptions.SfenceException;
import exceptions.SuffixException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Explorer;
import modelchecker.Memory;
import modelchecker.MyHashSet;
import modelchecker.MyStack;
import modelchecker.Process;
import modelchecker.TransitionAndSuccessor;
import modelchecker.pso.PsoState;
import modelchecker.pso.StateStaticParts;
import options.Options;

public class PsoExplorer
extends Explorer {
    private StateStaticParts sSPs;

    public PsoExplorer(ControlGraphs controlGraphs, Vector<Vector<Integer>> vector) {
        super(vector);
        this.controlGraphs = controlGraphs;
        this.stack = new MyStack();
        this.sSPs = new StateStaticParts();
        this.hashTable = new MyHashSet();
        this.initExploration();
    }

    public void initExploration() {
        Memory memory = this.controlGraphs.initMemory();
        Process[] processArray = this.controlGraphs.initProcesses();
        Buffer[] bufferArray = this.controlGraphs.initBuffer(2);
        this.initialState = new PsoState(null, memory, processArray, bufferArray);
        this.stack.push(this.initialState);
    }

    @Override
    public synchronized void storeState(AbstractState abstractState) {
        ++this.nbStatesStored;
        this.hashTable.add(abstractState);
        this.sSPs.addState((PsoState)abstractState);
    }

    @Override
    public synchronized boolean contains(AbstractState abstractState) {
        return this.hashTable.contains(abstractState);
    }

    @Override
    public synchronized AbstractState visited(AbstractState abstractState) {
        if (this.hashTable.contains(abstractState)) {
            return this.hashTable.get(abstractState);
        }
        return null;
    }

    public synchronized Vector<AbstractState> included(AbstractState abstractState) {
        return this.sSPs.included((PsoState)abstractState);
    }

    @Override
    public void removeState(AbstractState abstractState) {
        this.hashTable.remove(abstractState);
        this.sSPs.removeState((PsoState)abstractState);
        --this.nbStatesStored;
    }

    public synchronized boolean includedIn(AbstractState abstractState) {
        return this.sSPs.included((PsoState)abstractState) != null;
    }

    private PsoState getStateOnStack(PsoState psoState) {
        return (PsoState)this.stack.elementAt(this.stack.indexOf(psoState));
    }

    public int getNbStates() {
        return this.hashTable.size();
    }

    @Override
    protected void DFS() throws MfenceException, SuffixException, NoRelaxationException, Exception, SfenceException {
        Object object;
        PsoState psoState = (PsoState)this.stack.peek();
        AbstractState abstractState = null;
        Vector<AbstractState> vector = null;
        Vector<TransitionAndSuccessor> vector2 = null;
        HashSet<Transition> hashSet = null;
        this.printInfo();
        abstractState = this.visited(psoState);
        vector = this.included(psoState);
        if (psoState.getEqualState() != null && !psoState.equals(psoState.getEqualState())) {
            System.out.println("not possible");
        }
        if (abstractState != null || vector != null) {
            if (abstractState != null) {
                hashSet = new HashSet<Transition>();
                hashSet.addAll(abstractState.getSleepSet());
                if (abstractState != psoState && !psoState.getFromDelayFlag()) {
                    psoState.setEqualState(abstractState);
                    psoState.setStateType(2);
                }
            }
            if (vector != null) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashSet.addAll(vector.elementAt(0).getSleepSet());
                }
                for (AbstractState object22 : vector) {
                    hashSet.retainAll(object22.getSleepSet());
                }
                psoState.setIncludingVector(vector);
                if (abstractState == null) {
                    psoState.setStateType(1);
                } else {
                    psoState.setStateType(3);
                }
            }
            object = new Vector();
            ((Vector)object).addAll(hashSet);
            ((Vector)object).removeAll(psoState.getSleepSet());
            this.sort((Vector<Transition>)object);
            vector2 = psoState.computeT(this.controlGraphs, (Vector<Transition>)object);
        } else {
            psoState.setStateType(0);
            vector2 = psoState.computeT(this.controlGraphs);
            object = vector2.iterator();
            while (object.hasNext()) {
                Transition transition = object.next().getTransition();
                if (!psoState.getSleepSet().contains(transition)) continue;
                object.remove();
            }
        }
        if (Options.getProperty() == 0 && Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0) {
            this.sort2KeepPartialErrorState(psoState, vector2);
        }
        if (!psoState.getFromDelayFlag()) {
            if (Options.getProperty() == 0 && psoState.isErrorState()) {
                if (Options.getExplorationMode() == 0) {
                    throw new Exception("First Error");
                }
                if (Options.getExplorationMode() == 2) {
                    object = psoState.searchLastRelaxation(this.controlGraphs);
                    Transition transition = ((Transition)object).getControlGraph().putSfence((Transition)object);
                    Explorer.addInsertedFence(transition);
                    throw new SfenceException();
                }
            } else if (Options.getProperty() == 1 && psoState.isDeadlockState()) {
                if (Options.getExplorationMode() == 0) {
                    throw new Exception("First Error");
                }
                if (Options.getExplorationMode() == 2) {
                    object = psoState.searchLastRelaxation(this.controlGraphs);
                    Transition transition = ((Transition)object).getControlGraph().putSfence((Transition)object);
                    Explorer.addInsertedFence(transition);
                    throw new SfenceException();
                }
            }
        }
        if (abstractState == null) {
            this.storeState(psoState);
        } else {
            psoState.setEqualState(abstractState);
            psoState.getSleepSet().retainAll(hashSet);
            abstractState.getSleepSet().clear();
            abstractState.getSleepSet().addAll(psoState.getSleepSet());
            if (vector != null) {
                for (AbstractState abstractState2 : vector) {
                    abstractState2.getSleepSet().clear();
                    abstractState2.getSleepSet().addAll(psoState.getSleepSet());
                }
            }
        }
        ++this.nbStatesVisited;
        object = new HashSet<Transition>();
        ((AbstractCollection)object).addAll(psoState.getSleepSet());
        for (TransitionAndSuccessor transitionAndSuccessor : vector2) {
            Transition transition = transitionAndSuccessor.getTransition();
            PsoState psoState2 = (PsoState)transitionAndSuccessor.getAbstractState();
            psoState2.updateSleepSetIndependence(transition, (HashSet<Transition>)object);
            this.currDepth = this.stack.size();
            if (this.stack.contains(psoState2)) {
                PsoState psoState3 = this.getStateOnStack(psoState2);
                if (!psoState3.equals(psoState2)) {
                    System.out.println("also not possible");
                }
                psoState3.addSetToDelaySet(psoState2.getSleepSet());
            } else {
                if (transition.getType() == 3) {
                    this.incrementCommitCounter();
                } else {
                    this.incrementOtherOpsCounter();
                }
                psoState2.clearDelay();
                psoState.addSuccessor(psoState2);
                this.stack.push(psoState2);
                if (this.maxDepth < this.currDepth) {
                    this.maxDepth = this.currDepth;
                }
                this.DFS();
            }
            ((HashSet)object).add(transition);
        }
        psoState = (PsoState)this.stack.pop();
        if (psoState.delaySetSize() > 0) {
            psoState.getSleepSet().clear();
            psoState.getSleepSet().addAll(psoState.getAndRemoveDelaySet());
            psoState.setFromDelayFlag(true);
            this.stack.push(psoState);
            this.DFS();
        }
    }

    private void sort(Vector<Transition> vector) {
        int n;
        Transition[] transitionArray = new Transition[vector.size()];
        vector.toArray(transitionArray);
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < transitionArray.length; ++n) {
            if (transitionArray[n].getType() != 3) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        n3 = n2 + 1;
        block1: while (n3 < transitionArray.length) {
            Transition transition;
            if (transitionArray[n3].getType() == 3) {
                ++n3;
                continue;
            }
            Transition transition2 = transitionArray[n2];
            transitionArray[n2] = transition = transitionArray[n3];
            transitionArray[n3] = transition2;
            ++n2;
            ++n3;
            while (n2 < transitionArray.length) {
                if (transitionArray[n2].getType() == 3) {
                    n3 = n2 >= n3 ? n2 + 1 : n3 + 1;
                    continue block1;
                }
                if (n2 < transitionArray.length) {
                    ++n2;
                    continue;
                }
                ++n2;
                n3 = transitionArray.length;
            }
        }
        vector.clear();
        for (n = 0; n < transitionArray.length; ++n) {
            vector.add(transitionArray[n]);
        }
    }

    private void sort2KeepPartialErrorState(PsoState psoState, Vector<TransitionAndSuccessor> vector) {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        PsoState psoState2 = psoState;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = iterator.next();
            if (transitionAndSuccessor.getTransition().getType() == 3 || !PsoExplorer.isPartialErrorStateProcess(psoState2, transitionAndSuccessor.getTransition().getNbProcess())) continue;
            vector2.add(transitionAndSuccessor);
            iterator.remove();
        }
        for (TransitionAndSuccessor transitionAndSuccessor : vector2) {
            vector.add(transitionAndSuccessor);
        }
    }

    @Override
    public void finish() {
        if (Options.getVerbose()) {
            this.printStoreBufferContents();
        }
        if (Options.getPrintGlobalStateSpace() || Options.getPrintErrorTraces() || Options.getPrintStateBuffers()) {
            this.printStates();
        }
        if (Options.getPrintErrorTraces()) {
            this.initialState.printErrorTraces();
        }
    }

    public void printStates() {
        this.initialState.setStateNumbersAntText(0, Options.getPrintStateBuffers());
        if (Options.getPrintGlobalStateSpace()) {
            this.initialState.globalDot();
        }
    }

    public void printStoreBufferContents() {
        BufferContent.printBufferContents();
    }
}

