/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.pso;

import buffer.Buffer;
import buffer.BufferContent;
import buffer.BufferStoreContent;
import controlgraph.Action;
import controlgraph.ControlGraphs;
import controlgraph.Expression;
import controlgraph.Node;
import controlgraph.Transition;
import controlgraph.actions.Assign;
import controlgraph.actions.Commit;
import controlgraph.actions.LD;
import controlgraph.actions.LDDIFF;
import controlgraph.actions.LDV;
import controlgraph.actions.ST;
import controlgraph.actions.SfenceStatement;
import exceptions.BufferSfenceException;
import exceptions.NoRelaxationException;
import exceptions.SuffixException;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Memory;
import modelchecker.MemoryVariable;
import modelchecker.Process;
import modelchecker.TransitionAndSuccessor;
import modelchecker.pso.PsoExplorer;
import options.Constants;
import options.Options;

public class PsoState
extends AbstractState
implements Cloneable {
    private Buffer[] buffers;
    private Buffer[] TSOlikeBuffer;
    private Vector<AbstractState> includedIn = null;
    private Vector<AbstractState> includingOrEquals = null;
    private boolean bufferCleared = false;
    private ControlGraphs controlGraphs;
    private Vector<Vector<Transition>> delay = new Vector();
    private boolean cycleFlag = false;
    private PsoState cycleFrom = null;
    private int cycleType = 0;
    private int cycleProcess = -1;
    private Buffer[] suffixCycle;
    private Buffer suffixCycleTSO;
    private boolean[] constructTSOBuffer;
    private boolean reducedBuffer = false;
    private boolean PSOrelaxation = false;

    public PsoState(AbstractState abstractState, Memory memory, Process[] processArray, Buffer[] bufferArray) {
        super(abstractState, memory, processArray);
        this.buffers = bufferArray;
        this.TSOlikeBuffer = new Buffer[processArray.length];
        this.constructTSOBuffer = new boolean[processArray.length];
        for (int i = 0; i < this.TSOlikeBuffer.length; ++i) {
            this.TSOlikeBuffer[i] = new Buffer();
            this.constructTSOBuffer[i] = true;
        }
    }

    public Buffer getTSOlikeBuffer(int n) {
        return (Buffer)this.TSOlikeBuffer[n].clone();
    }

    public String toString() {
        this.text = this.nbGlobalState + ": (";
        for (int i = 0; i < this.processes.length; ++i) {
            this.text = this.text + this.processes[i].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        return this.text;
    }

    public void setBufferClearedFlag(boolean bl) {
        this.bufferCleared = bl;
    }

    public void addIncludingOrEqualState(AbstractState abstractState) {
        if (this.includingOrEquals == null) {
            this.includingOrEquals = new Vector();
        }
        this.includingOrEquals.add(abstractState);
    }

    public boolean emptyBuffers() {
        return this.bufferCleared;
    }

    public void setIncludingVector(Vector<AbstractState> vector) {
        this.includedIn = vector;
    }

    public Vector<TransitionAndSuccessor> computeT(ControlGraphs controlGraphs, Vector<Transition> vector) throws SuffixException {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        for (Transition transition : vector) {
            Vector<PsoState> vector3 = this.computeSuccessor(transition, transition.getNbProcess());
            if (vector3 == null) continue;
            for (PsoState psoState : vector3) {
                if (psoState == null) continue;
                vector2.add(new TransitionAndSuccessor(transition, psoState));
            }
        }
        this.removeDisabledTransitions(vector2);
        return vector2;
    }

    public Vector<TransitionAndSuccessor> computeT(ControlGraphs controlGraphs) throws SuffixException {
        Vector<TransitionAndSuccessor> vector = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        this.computeTransitionsAndSuccessors(vector);
        if (Options.getProperty() == 1) {
            this.check4Deadlock(vector);
        }
        this.computePersistentSet(vector);
        this.removeDisabledTransitions(vector);
        return vector;
    }

    public Vector<TransitionAndSuccessor> computeEnabled(ControlGraphs controlGraphs) throws SuffixException {
        Vector<TransitionAndSuccessor> vector = new Vector<TransitionAndSuccessor>();
        this.controlGraphs = controlGraphs;
        this.computeTransitionsAndSuccessors(vector);
        if (Options.getProperty() == 1) {
            this.check4Deadlock(vector);
        }
        this.removeDisabledTransitions(vector);
        return vector;
    }

    private void computeTransitionsAndSuccessors(Vector<TransitionAndSuccessor> vector) throws SuffixException {
        int n;
        Vector<PsoState> vector2 = null;
        Transition transition = null;
        for (n = 0; n < this.processes.length; ++n) {
            Node node = this.processes[n].getCurrentNode();
            Iterator<Transition> iterator = node.getTransitionsIterator();
            while (iterator.hasNext()) {
                transition = iterator.next();
                vector2 = this.computeSuccessor(transition, n);
                if (vector2 == null) continue;
                for (PsoState object : vector2) {
                    vector.add(new TransitionAndSuccessor(transition, object));
                }
            }
        }
        n = this.controlGraphs.getGlobalVariableNumber();
        for (int i = 0; i < this.processes.length; ++i) {
            for (int j = 0; j < n; ++j) {
                Object object2 = this.buffers[i * n + j].getOutTransitionsFromInit();
                if (object2 == null) continue;
                Node node = this.processes[i].getCurrentNode();
                for (Object object : object2) {
                    BufferStoreContent bufferStoreContent = BufferContent.getStoreContent((char)object);
                    Commit commit = new Commit(this.processes[i], bufferStoreContent, this.controlGraphs.getControlGraph(i));
                    transition = new Transition(node, node, "Commit", i, null, 3, commit);
                    vector2 = this.computeSuccessor(transition, i);
                    for (PsoState psoState : vector2) {
                        vector.add(new TransitionAndSuccessor(transition, psoState));
                    }
                }
            }
        }
    }

    private Vector<PsoState> computeSuccessor(Transition transition, int n) throws SuffixException {
        Vector<PsoState> vector;
        switch (transition.getType()) {
            case 3: {
                vector = this.commit(transition, n);
                break;
            }
            case 0: {
                vector = this.store(transition, n);
                break;
            }
            case 5: {
                vector = this.local(transition, n);
                break;
            }
            case 1: {
                vector = this.load(transition, n);
                break;
            }
            case 6: {
                vector = this.lock(transition, n);
                break;
            }
            case 7: {
                vector = this.unlock(transition, n);
                break;
            }
            case 4: {
                vector = this.mfence(transition, n);
                break;
            }
            case 14: {
                vector = this.sfence(transition, n);
                break;
            }
            case 13: {
                vector = this.boolOp(transition, n);
                break;
            }
            case 2: {
                vector = this.loadVal(transition, n);
                break;
            }
            default: {
                throw new InternalError("something special to happen - " + transition.getType());
            }
        }
        for (PsoState psoState : vector) {
            if (psoState != null) {
                psoState.cycleFlag = false;
                psoState.cycleFrom = null;
                psoState.cycleType = 0;
                psoState.suffixCycle = null;
                psoState.suffixCycleTSO = null;
                psoState.cycleProcess = -1;
                psoState.errorFlag = false;
                psoState.delay.clear();
                psoState.equalState = null;
                if (psoState.includedIn != null) {
                    psoState.includedIn.clear();
                }
                psoState.fromDelayFlag = false;
                psoState.stateType = 4;
            }
            if (psoState == null) continue;
            psoState.cycleDetection(psoState.advancedProcess);
        }
        return vector;
    }

    private Vector<PsoState> commit(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        Commit commit = (Commit)transition.getAction();
        BufferStoreContent bufferStoreContent = commit.getBufferStoreContent();
        int n2 = bufferStoreContent.getId();
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        psoState.processes[n].pushLocalMem2ControlGraphMem();
        psoState.reducedBuffer = false;
        if (bufferStoreContent.getId() == Options.getNbGlobalVars()) {
            for (int i = 0; i < n3; ++i) {
                char c = BufferContent.getChar(bufferStoreContent);
                if (!psoState.buffers[n * n3 + i].checkPossibleCommit(c)) {
                    vector.add(null);
                    return vector;
                }
                transition.apply(psoState.buffers[n * n3 + i]);
            }
        } else {
            Buffer buffer = psoState.buffers[n * n3 + n2];
            if (!buffer.checkPossibleCommit(BufferContent.getChar(bufferStoreContent))) {
                vector.add(null);
                return vector;
            }
            transition.apply(buffer);
            Vector<Buffer> vector2 = new Vector<Buffer>();
            for (int i = 0; i < n3; ++i) {
                vector2.add(psoState.buffers[n * n3 + i]);
            }
            try {
                if (this.updateBuffersForSfence(vector2, n2)) {
                    psoState.reducedBuffer = true;
                }
            }
            catch (BufferSfenceException bufferSfenceException) {
                vector.add(null);
                return vector;
            }
            if (this.constructTSOBuffer[n]) {
                Buffer buffer2 = psoState.TSOlikeBuffer[n];
                char c = BufferContent.getChar(bufferStoreContent);
                if (buffer2.checkPossibleCommit(c)) {
                    psoState.PSOrelaxation = false;
                    transition.apply(buffer2);
                    psoState.constructTSOBuffer[n] = true;
                } else {
                    psoState.PSOrelaxation = true;
                    psoState.constructTSOBuffer[n] = false;
                    psoState.TSOlikeBuffer[n].resetBuffer();
                }
            }
            if (!this.constructTSOBuffer[n] && psoState.restartTSOBufferConstruction(n)) {
                psoState.TSOlikeBuffer[n].resetBuffer();
                psoState.constructTSOBuffer[n] = true;
            }
            if (buffer.isEmpty() || this.lock.locked() != n && this.lock.locked() != -1) {
                vector.add(null);
                return vector;
            }
            psoState.memory.setMemory(bufferStoreContent.getId(), bufferStoreContent.isBool(), bufferStoreContent.intValue(), bufferStoreContent.boolValue());
        }
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 3;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> store(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        psoState.processes[n].pushLocalMem2ControlGraphMem();
        ST sT = (ST)transition.getAction();
        int n2 = sT.getVarId();
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        Buffer buffer = psoState.buffers[n * n3 + n2];
        BufferStoreContent bufferStoreContent = sT.getStoreContent(buffer);
        transition.apply(buffer);
        if (this.constructTSOBuffer[n]) {
            transition.apply(psoState.TSOlikeBuffer[n]);
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = bufferStoreContent;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 0;
        psoState.reducedBuffer = false;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> local(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        psoState.processes[n].pushLocalMem2ControlGraphMem();
        if (!transition.isTrue(this.emptyBuffer())) {
            vector.add(null);
            return vector;
        }
        if (transition.getAction().type() != 20) {
            transition.apply(null);
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.processes[n].popLocalMemFromControlGraphMem();
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 5;
        psoState.reducedBuffer = false;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> load(Transition transition, int n) {
        int n2;
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        psoState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        Action action = transition.getAction();
        if (action instanceof LD) {
            n2 = ((LD)action).getVarId();
        } else if (action instanceof LDDIFF) {
            n2 = ((LDDIFF)action).getVarId();
        } else {
            throw new InternalError("must be either LDDIFF or LD");
        }
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        Buffer buffer = psoState.buffers[n3 * n + n2];
        if (!transition.isTrue(buffer) || this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        if (action instanceof LD) {
            psoState.reducedBuffer = ((LD)transition.getAction()).bufferModified();
        } else if (action instanceof LDDIFF) {
            psoState.reducedBuffer = ((LDDIFF)transition.getAction()).bufferModified();
        }
        Vector<Buffer> vector2 = new Vector<Buffer>();
        for (int i = 0; i < n3; ++i) {
            vector2.add(psoState.buffers[n * n3 + i]);
        }
        try {
            if (this.updateBuffersForSfence(vector2, n2)) {
                if (action instanceof LD) {
                    ((LD)action).setBufferModified(true);
                } else if (action instanceof LDDIFF) {
                    ((LDDIFF)action).setBufferModified(true);
                }
                psoState.reducedBuffer = true;
            }
        }
        catch (BufferSfenceException bufferSfenceException) {
            vector.add(null);
            return vector;
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 1;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> loadVal(Transition transition, int n) {
        int n2;
        Vector<PsoState> vector = new Vector<PsoState>();
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        PsoState psoState = (PsoState)this.clone();
        BufferStoreContent bufferStoreContent = null;
        boolean bl = false;
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        Vector<BufferStoreContent> vector2 = psoState.buffers[n3 * n + (n2 = ((Assign)transition.getAction()).loadsVar())].prepareLoadBuffer(n2);
        if (vector2.lastElement() == null) {
            vector2.removeElementAt(vector2.size() - 1);
            MemoryVariable memoryVariable = psoState.memory.getMemoryVariableAt(n2);
            LDV lDV = (LDV)((Assign)transition.getAction()).getExpression();
            bufferStoreContent = new BufferStoreContent(n2, memoryVariable.isBool(), memoryVariable.boolValue(), memoryVariable.intValue(), lDV.getGlobalVariable().getName(), null);
            if (!vector2.contains(bufferStoreContent)) {
                vector2.add(bufferStoreContent);
            }
            bl = true;
        }
        boolean bl2 = vector2.size() != 1;
        for (BufferStoreContent bufferStoreContent2 : vector2) {
            psoState = (PsoState)this.clone();
            psoState.processes[n].pushLocalMem2ControlGraphMem();
            this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
            ((Assign)transition.getAction()).apply(bufferStoreContent2);
            psoState.processes[n].popLocalMemFromControlGraphMem();
            psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
            psoState.buffers[n3 * n + n2] = bl && bufferStoreContent2.equals(bufferStoreContent) ? psoState.buffers[n3 * n + n2].getCorrespondingBuffer(bufferStoreContent2, true) : psoState.buffers[n3 * n + n2].getCorrespondingBuffer(bufferStoreContent2, false);
            Vector<Buffer> vector3 = new Vector<Buffer>();
            for (int i = 0; i < n3; ++i) {
                vector3.add(psoState.buffers[n * n3 + i]);
            }
            LDV lDV = (LDV)((Assign)transition.getAction()).getExpression();
            try {
                if (this.updateBuffersForSfence(vector3, n2)) {
                    psoState.reducedBuffer = true;
                    lDV.setBufferModified(true);
                } else {
                    psoState.reducedBuffer = bl2;
                    lDV.setBufferModified(bl2);
                }
            }
            catch (BufferSfenceException bufferSfenceException) {
                continue;
            }
            psoState.bSC = null;
            psoState.pred = this;
            psoState.succ = null;
            psoState.advancedProcess = n;
            psoState.tFollowed = transition;
            psoState.operationType = 2;
            vector.add(psoState);
        }
        if (vector.size() == 0) {
            vector.add(null);
        }
        return vector;
    }

    private Vector<PsoState> lock(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        if (this.lock.locked() != -1 && this.lock.locked() != n) {
            vector.add(null);
            return vector;
        }
        PsoState psoState = (PsoState)this.clone();
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.lock.getLock(n);
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 6;
        psoState.reducedBuffer = false;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> mfence(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        for (int i = n2 * n; i < n2 * (n + 1); ++i) {
            if (!psoState.buffers[i].acceptsEmptyString()) {
                vector.add(null);
                return vector;
            }
            psoState.reducedBuffer = psoState.buffers[i].resetBuffer();
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 4;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> sfence(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        SfenceStatement sfenceStatement = (SfenceStatement)transition.getAction();
        sfenceStatement.setTransition(transition);
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        for (int i = 0; i < n2; ++i) {
            transition.apply(psoState.buffers[n2 * n + i]);
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 14;
        psoState.reducedBuffer = false;
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> unlock(Transition transition, int n) {
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        if (this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        for (int i = n2 * n; i < n2 * (n + 1); ++i) {
            if (!psoState.buffers[i].acceptsEmptyString()) {
                vector.add(null);
                return vector;
            }
            psoState.reducedBuffer = psoState.buffers[i].resetBuffer();
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 7;
        psoState.lock.releaseLock();
        vector.add(psoState);
        return vector;
    }

    private Vector<PsoState> boolOp(Transition transition, int n) {
        int n2;
        Vector<PsoState> vector = new Vector<PsoState>();
        PsoState psoState = (PsoState)this.clone();
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        Vector<Buffer> vector2 = new Vector<Buffer>();
        for (n2 = 0; n2 < n3; ++n2) {
            vector2.add(psoState.buffers[n * n3 + n2]);
        }
        psoState.processes[n].pushLocalMem2ControlGraphMem();
        this.pushGlobalMem2ControlGraphsMem(this.controlGraphs);
        if (!transition.isTrue(vector2)) {
            vector.add(null);
            return vector;
        }
        if (transition.containsLoad() != -1 && this.lock.locked() != n && this.lock.locked() != -1) {
            vector.add(null);
            return vector;
        }
        if (transition.containsLoad() != -1) {
            int n4;
            Vector<Buffer> vector3 = new Vector<Buffer>();
            for (n4 = 0; n4 < n3; ++n4) {
                vector3.add(psoState.buffers[n * n3 + n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (!transition.containsLoadAt(n4)) continue;
                try {
                    this.updateBuffersForSfence(vector3, n4);
                    continue;
                }
                catch (BufferSfenceException bufferSfenceException) {
                    vector.add(null);
                    return vector;
                }
            }
        }
        psoState.processes[n].setControlLocation(transition.getTargetNode().getNbNode());
        psoState.bSC = null;
        psoState.pred = this;
        psoState.succ = null;
        psoState.advancedProcess = n;
        psoState.tFollowed = transition;
        psoState.operationType = 13;
        if (transition.containsLoad() == -1) {
            psoState.reducedBuffer = false;
        } else {
            psoState.reducedBuffer = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.buffers[n * n3 + n2].equals(psoState.buffers[n * n3 + n2])) continue;
                psoState.reducedBuffer = true;
                break;
            }
        }
        vector.add(psoState);
        return vector;
    }

    private boolean updateBuffersForSfence(Vector<Buffer> vector, int n) throws BufferSfenceException {
        Vector<Buffer> vector2 = new Vector<Buffer>();
        for (Buffer buffer : vector) {
            vector2.add((Buffer)buffer.clone());
        }
        Buffer.updateForSfence(vector, n);
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(vector2.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    private void cycleDetection(int n) throws SuffixException {
        BufferStoreContent bufferStoreContent;
        Vector<Buffer> vector;
        if (this.cycleStopCondition(this, n)) {
            return;
        }
        Buffer[] bufferArray = new Buffer[this.memory.getNbVars()];
        for (int i = 0; i < bufferArray.length; ++i) {
            bufferArray[i] = new Buffer();
        }
        Vector<Vector<Buffer>> vector2 = new Vector<Vector<Buffer>>();
        for (int i = 0; i < this.memory.getNbVars(); ++i) {
            vector = new Vector<Buffer>();
            vector2.add(vector);
        }
        Buffer buffer = new Buffer();
        vector = new Vector();
        BufferStoreContent[] bufferStoreContentArray = new BufferStoreContent[this.getMemory().getNbVars()];
        for (int i = 0; i < bufferStoreContentArray.length; ++i) {
            bufferStoreContentArray[i] = null;
        }
        if (this.getOperationType() == 0 && this.advancedProcess == n && (bufferStoreContent = this.getBufferStoreContent()) != null) {
            if (bufferStoreContentArray[bufferStoreContent.getId()] == null) {
                bufferStoreContentArray[bufferStoreContent.getId()] = bufferStoreContent;
            }
            bufferArray[bufferStoreContent.getId()].addStore(bufferStoreContent);
            buffer.addStore(bufferStoreContent);
        }
        PsoState psoState = (PsoState)this.pred;
        while (psoState != null) {
            Cloneable cloneable;
            int n2 = this.cycleSimilar(psoState, n, bufferStoreContentArray, vector2, bufferArray, vector, buffer);
            switch (n2) {
                case 2: {
                    return;
                }
            }
            if (this.cycleStopCondition(psoState, n)) {
                return;
            }
            if (psoState.advancedProcess == n && (!psoState.cycleFlag || psoState.cycleFlag && psoState.cycleProcess != n)) {
                for (int i = 0; i < bufferArray.length; ++i) {
                    cloneable = Buffer.getUnionStar(vector2.elementAt(i));
                    bufferArray[i] = Buffer.getConcatenation((Buffer)cloneable, bufferArray[i]);
                    vector2.elementAt(i).clear();
                }
                Buffer buffer2 = Buffer.getUnionStar(vector);
                buffer = Buffer.getConcatenation(buffer2, buffer);
                vector.clear();
                if (psoState.tFollowed.getType() == 0) {
                    bufferArray[psoState.bSC.getId()].addStoreBefore(psoState.bSC);
                    buffer.addStoreBefore(psoState.bSC);
                } else if (psoState.tFollowed.getType() == 14) {
                    cloneable = new BufferStoreContent(psoState.tFollowed);
                    for (int i = 0; i < this.memory.getNbVars(); ++i) {
                        bufferArray[i].addStoreBefore((BufferStoreContent)cloneable);
                    }
                }
                cloneable = psoState.bSC;
                if (cloneable != null && bufferStoreContentArray[((BufferStoreContent)cloneable).getId()] == null) {
                    bufferStoreContentArray[((BufferStoreContent)cloneable).getId()] = cloneable;
                }
                psoState = (PsoState)psoState.pred;
                continue;
            }
            if (psoState.cycleFlag && psoState.cycleProcess == n) {
                if (psoState.cycleType == 2) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector2.elementAt(i).add(psoState.suffixCycle[i]);
                    }
                    vector.add(psoState.suffixCycleTSO);
                } else {
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector2.elementAt(i).add(psoState.suffixCycle[i]);
                        cloneable = Buffer.getUnionStar(vector2.elementAt(i));
                        bufferArray[i] = Buffer.getConcatenation((Buffer)cloneable, bufferArray[i]);
                        vector2.elementAt(i).clear();
                    }
                    vector.add(psoState.suffixCycleTSO);
                    Buffer buffer3 = Buffer.getUnionStar(vector);
                    buffer = Buffer.getConcatenation(buffer3, buffer);
                    vector.clear();
                }
                psoState = psoState.cycleFrom;
                continue;
            }
            psoState = (PsoState)psoState.pred;
        }
    }

    private boolean cycleStopCondition(PsoState psoState, int n) {
        if (psoState.advancedProcess != n) {
            return false;
        }
        Transition transition = psoState.tFollowed;
        int n2 = transition.getType();
        if (n2 == 3 || n2 == 4 || n2 == 6 || n2 == 7) {
            return true;
        }
        return (n2 == 1 || n2 == 2 || n2 == 13) && psoState.reducedBuffer;
    }

    private int cycleSimilar(PsoState psoState, int n, BufferStoreContent[] bufferStoreContentArray, Vector<Vector<Buffer>> vector, Buffer[] bufferArray, Vector<Buffer> vector2, Buffer buffer) throws SuffixException {
        int n2;
        if (!this.memory.equals(psoState.memory)) {
            return 1;
        }
        for (n2 = 0; n2 < this.processes.length; ++n2) {
            if (!this.processes[n2].equals(psoState.processes[n2])) {
                return 1;
            }
            if (n2 == n || this.equalBuffers(psoState, this, n2)) continue;
            return 1;
        }
        n2 = 0;
        if (!this.buffersStrongLoadEquivalent(psoState, this, n, bufferStoreContentArray)) {
            return 1;
        }
        n2 = 1;
        Buffer[] bufferArray2 = new Buffer[this.memory.getNbVars()];
        for (int i = 0; i < bufferArray2.length; ++i) {
            bufferArray2[i] = Buffer.getUnionStar(vector.elementAt(i));
            bufferArray2[i] = Buffer.getConcatenation(bufferArray2[i], bufferArray[i]);
        }
        Buffer buffer2 = Buffer.getUnionStar(vector2);
        buffer2 = Buffer.getConcatenation(buffer2, buffer);
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        int n4 = n3 * n;
        int n5 = n4 + n3;
        if (n2 != 0) {
            if (psoState.checkStrongParallel(n, bufferStoreContentArray)) {
                int n6;
                this.cycleFlag = true;
                this.cycleFrom = psoState;
                this.cycleProcess = n;
                this.cycleType = 2;
                this.suffixCycle = bufferArray2;
                this.suffixCycleTSO = buffer2;
                Vector<Buffer> vector3 = new Vector<Buffer>();
                for (n6 = n4; n6 < n5; ++n6) {
                    vector3.add(bufferArray2[n6 - n4]);
                }
                Vector<Buffer> vector4 = psoState.makeStrongCycle(vector3, buffer2, n);
                for (n6 = n4; n6 < n5; ++n6) {
                    this.buffers[n6].setAutomaton(vector4.elementAt(n6 - n4).getAutomaton());
                }
                if (this.constructTSOBuffer[n]) {
                    this.TSOlikeBuffer[n].setAutomaton(vector4.lastElement().getAutomaton());
                }
            } else {
                this.cycleFlag = true;
                this.cycleFrom = psoState;
                this.cycleProcess = n;
                this.cycleType = 3;
                this.suffixCycle = bufferArray2;
                this.suffixCycleTSO = buffer2;
                for (int i = n4; i < n5; ++i) {
                    this.buffers[i].makeWeakCycleWithSuffix(psoState.buffers[i], bufferArray2[i - n4], 0);
                }
                if (this.constructTSOBuffer[n]) {
                    this.TSOlikeBuffer[n].makeWeakCycleWithSuffix(psoState.TSOlikeBuffer[n], buffer2, 0);
                }
            }
        } else {
            return 1;
        }
        return 2;
    }

    private boolean checkStrongParallel(int n, BufferStoreContent[] bufferStoreContentArray) {
        PsoState psoState = this;
        if (psoState != null) {
            if (psoState.cycleFlag && psoState.cycleProcess == n) {
                return this.buffersStrongLoadEquivalent(this, psoState, n, bufferStoreContentArray);
            }
            return false;
        }
        return false;
    }

    private Vector<Buffer> makeStrongCycle(Vector<Buffer> vector, Buffer buffer, int n) {
        Object object;
        int n2;
        Vector<Buffer> vector2;
        Cloneable cloneable222;
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        int n4 = n3 * n;
        int n5 = n4 + n3;
        Vector<Buffer> vector3 = new Vector<Buffer>();
        Vector vector4 = new Vector();
        for (Cloneable cloneable222 : vector) {
            vector2 = new Vector<Buffer>();
            vector2.add((Buffer)cloneable222.clone());
            vector4.add(vector2);
            vector3.add(new Buffer());
        }
        Vector vector5 = new Vector();
        vector5.add((Buffer)buffer.clone());
        vector3.add(new Buffer());
        cloneable222 = this;
        vector2 = new Vector();
        Buffer buffer2 = null;
        boolean bl = false;
        while (cloneable222 != null) {
            int n6;
            if (((PsoState)cloneable222).cycleFlag && ((PsoState)cloneable222).cycleProcess == n && ((PsoState)cloneable222).cycleType == 2) {
                n6 = 0;
                for (Vector cloneable3 : vector4) {
                    cloneable3.add((Buffer)((PsoState)cloneable222).suffixCycle[n6].clone());
                    ++n6;
                }
                vector5.add((Buffer)((PsoState)cloneable222).suffixCycleTSO.clone());
                cloneable222 = ((PsoState)cloneable222).cycleFrom;
                bl = false;
                continue;
            }
            if (((PsoState)cloneable222).cycleFlag && ((PsoState)cloneable222).cycleProcess == n && ((PsoState)cloneable222).cycleType == 3) {
                n6 = 0;
                for (Vector vector6 : vector4) {
                    vector6.add((Buffer)((PsoState)cloneable222).suffixCycle[n6].clone());
                    ++n6;
                }
                vector5.add((Buffer)((PsoState)cloneable222).suffixCycleTSO.clone());
                for (n6 = n4; n6 < n5; ++n6) {
                    vector3.set(n6 - n4, (Buffer)((PsoState)cloneable222).cycleFrom.buffers[n6].clone());
                }
                vector3.set(n6 - n4, (Buffer)((PsoState)cloneable222).cycleFrom.TSOlikeBuffer[n].clone());
                bl = false;
                break;
            }
            for (n6 = n4; n6 < n5; ++n6) {
                vector3.set(n6 - n4, (Buffer)((PsoState)cloneable222).cycleFrom.buffers[n6].clone());
            }
            vector3.set(n6 - n4, (Buffer)((PsoState)cloneable222).cycleFrom.TSOlikeBuffer[n].clone());
        }
        for (n2 = 0; n2 < vector3.size() - 1; ++n2) {
            Buffer buffer3 = Buffer.getUnionStar((Vector)vector4.elementAt(n2));
            if (bl) {
                buffer3 = Buffer.getConcatenation((Buffer)vector2.elementAt(n2), buffer3);
            }
            object = (Buffer)vector3.elementAt(n2);
            Buffer buffer4 = buffer3;
            vector3.set(n2, Buffer.getConcatenation((Buffer)object, buffer4));
        }
        Buffer buffer4 = Buffer.getUnionStar(vector5);
        if (bl) {
            buffer4 = Buffer.getConcatenation(buffer2, buffer4);
        }
        object = (Buffer)vector3.elementAt(n2);
        Buffer buffer5 = buffer4;
        vector3.set(n2, Buffer.getConcatenation((Buffer)object, buffer5));
        return vector3;
    }

    private boolean buffersStrongLoadEquivalent(PsoState psoState, PsoState psoState2, int n, BufferStoreContent[] bufferStoreContentArray) {
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        int n3 = n2 * n;
        int n4 = n3 + n2;
        for (int i = n3; i < n4; ++i) {
            if (psoState2.buffers[i].strongLoadEquivalentPSO(psoState.buffers[i], psoState2.memory, psoState.memory, bufferStoreContentArray[i - n3])) continue;
            return false;
        }
        return true;
    }

    private boolean equalBuffers(PsoState psoState, PsoState psoState2, int n) {
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        int n3 = n2 * n;
        int n4 = n3 + n2;
        for (int i = n3; i < n4; ++i) {
            if (psoState.buffers[i].equals(psoState2.buffers[i])) continue;
            return false;
        }
        return true;
    }

    public void makeStrongCycles(PsoState psoState, PsoState psoState2, int n) {
        int n2 = this.controlGraphs.getGlobalVariableNumber();
        int n3 = n2 * n;
        int n4 = n3 + n2;
        for (int i = n3; i < n4; ++i) {
            psoState2.buffers[i].makeStrongCycle(psoState.buffers[i]);
        }
    }

    private void computePersistentSet(Vector<TransitionAndSuccessor> vector) {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        vector2.addAll(vector);
        Vector<TransitionAndSuccessor> vector3 = new Vector<TransitionAndSuccessor>();
        this.look4LocalProvisioTransition(vector, vector3);
        if (vector3.size() == 1) {
            this.computePersistentSet(vector, vector3);
            if (this.onlyLocals(vector3)) {
                vector.clear();
                vector.addAll(vector3);
            } else {
                vector.clear();
                vector.addAll(vector2);
            }
        } else {
            if (this.onlyLocalTransitions(vector)) {
                vector.clear();
                return;
            }
            if (this.noCommits(vector)) {
                Iterator<TransitionAndSuccessor> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    TransitionAndSuccessor transitionAndSuccessor = iterator.next();
                    int n = transitionAndSuccessor.getTransition().getType();
                    if (n != 3) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void look4LocalProvisioTransition(Vector<TransitionAndSuccessor> vector, Vector<TransitionAndSuccessor> vector2) {
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = iterator.next();
            int n = transitionAndSuccessor.getTransition().getType();
            if (n != 5 && n != 0 || n == 13 && transitionAndSuccessor.getTransition().getAction().containsLoad() != -1 || transitionAndSuccessor.getAbstractState() == null || Options.getProperty() != 1 && (Options.getProperty() != 0 || !this.proviso(transitionAndSuccessor) || PsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0))) continue;
            vector2.add(transitionAndSuccessor);
            iterator.remove();
            return;
        }
    }

    private boolean onlyLocals(Vector<TransitionAndSuccessor> vector) {
        for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            int n = transitionAndSuccessor.getTransition().getType();
            if (n != 5 && n != 0 && n != 6) {
                return false;
            }
            if (PsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && Options.getProperty() == 0 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0)) {
                return false;
            }
            if (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1) continue;
            return false;
        }
        return true;
    }

    private boolean onlyLocalTransitions(Vector<TransitionAndSuccessor> vector) {
        TransitionAndSuccessor transitionAndSuccessor;
        int n;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext() && (n = (transitionAndSuccessor = iterator.next()).getTransition().getType()) != 3) {
            if (n != 5 && n != 0) {
                return false;
            }
            if (PsoExplorer.isPartialErrorStateProcess(this, transitionAndSuccessor.getTransition().getNbProcess()) && Options.getProperty() == 0 && (Options.getExplorationMode() == 2 || Options.getExplorationMode() == 1 || Options.getExplorationMode() == 0)) {
                return false;
            }
            if (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1) continue;
            return false;
        }
        return true;
    }

    private boolean noCommits(Vector<TransitionAndSuccessor> vector) {
        TransitionAndSuccessor transitionAndSuccessor;
        int n;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext() && (n = (transitionAndSuccessor = iterator.next()).getTransition().getType()) != 3) {
            if (n == 5 && n == 0 && (n != 13 || transitionAndSuccessor.getTransition().getAction().containsLoad() == -1)) continue;
            return false;
        }
        return true;
    }

    private void computePersistentSet(Vector<TransitionAndSuccessor> vector, Vector<TransitionAndSuccessor> vector2) {
        block0: for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            Transition transition = transitionAndSuccessor.getTransition();
            for (TransitionAndSuccessor transitionAndSuccessor2 : vector2) {
                if (this.independent(transition, transitionAndSuccessor2.getTransition())) continue;
                vector2.add(transitionAndSuccessor);
                continue block0;
            }
        }
    }

    private boolean proviso(TransitionAndSuccessor transitionAndSuccessor) {
        Transition transition = transitionAndSuccessor.getTransition();
        PsoState psoState = (PsoState)transitionAndSuccessor.getAbstractState();
        PsoState psoState2 = (PsoState)psoState.pred;
        if (this.sleepSet.contains(transition)) {
            return false;
        }
        while (psoState2 != null) {
            if (psoState.equals(psoState2)) {
                return false;
            }
            psoState2 = (PsoState)psoState2.pred;
        }
        return true;
    }

    private void removeDisabledTransitions(Vector<TransitionAndSuccessor> vector) {
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getAbstractState() != null) continue;
            iterator.remove();
        }
    }

    public synchronized void updateSleepSetIndependence(Transition transition, HashSet<Transition> hashSet) {
        this.sleepSet = new HashSet();
        for (Transition transition2 : hashSet) {
            if (!this.independentSleepSet(transition, transition2)) continue;
            this.sleepSet.add(transition2);
        }
        if (this.cycleFlag && this.cycleProcess == this.advancedProcess) {
            PsoState psoState = this.cycleFrom;
            if (psoState.cycleFlag && psoState.cycleProcess == this.advancedProcess) {
                this.sleepSet.retainAll(psoState.getSleepSet());
            }
        }
    }

    private boolean independent(Transition transition, Transition transition2) {
        int n = transition.getNbProcess();
        int n2 = transition2.getNbProcess();
        int n3 = transition.getType();
        int n4 = transition2.getType();
        if (n == n2) {
            if ((n3 == 0 || n3 == 5 || n3 == 6) && n4 == 3) {
                return true;
            }
            if ((n4 == 0 || n4 == 5 || n4 == 6) && n3 == 3) {
                return true;
            }
            if (n3 == 13 && transition.containsLoad() == -1 && n4 == 3) {
                return true;
            }
            return n4 == 13 && transition2.containsLoad() == -1 && n3 == 3;
        }
        if (n3 == 3 && n4 == 1 || n3 == 3 && n4 == 3 || n3 == 1 && n4 == 3 || n3 == 2 && n4 == 3 || n3 == 3 && n4 == 2 || n3 == 6 && n4 == 6 || n3 == 7 && n4 == 6 || n3 == 7 && n4 == 6 || (n3 == 6 || n3 == 7) && (n4 == 1 || n4 == 2 || n4 == 3) || (n4 == 6 || n4 == 7) && (n3 == 1 || n3 == 2 || n3 == 3)) {
            return false;
        }
        if (n3 == 13 && transition.containsLoad() != -1 && n4 == 3) {
            return false;
        }
        return n4 != 13 || transition2.containsLoad() == -1 || n3 != 3;
    }

    private boolean independentSleepSet(Transition transition, Transition transition2) {
        BufferStoreContent bufferStoreContent;
        int n;
        Action action;
        int n2;
        BufferStoreContent bufferStoreContent2;
        Commit commit;
        int n3 = transition.getNbProcess();
        int n4 = transition2.getNbProcess();
        int n5 = transition.getType();
        int n6 = transition2.getType();
        if (n3 == n4) {
            int n7;
            int n8;
            Action action2;
            Commit commit2;
            if ((n5 == 0 || n5 == 5 || n5 == 6) && n6 == 3) {
                return true;
            }
            if ((n6 == 0 || n6 == 5 || n6 == 6) && n5 == 3) {
                return true;
            }
            if (n5 == 1 && n6 == 3) {
                commit2 = (Commit)transition2.getAction();
                action2 = transition.getAction();
                if (action2 instanceof LD && commit2.getNbPossibleCommits() == 1 && !((LD)action2).bufferModified()) {
                    return true;
                }
                if (action2 instanceof LDDIFF && commit2.getNbPossibleCommits() == 1 && !((LDDIFF)action2).bufferModified()) {
                    return true;
                }
                if (!(action2 instanceof LD) && !(action2 instanceof LDDIFF)) {
                    throw new InternalError("must be load or loaddiff");
                }
            }
            if (n6 == 1 && n5 == 3) {
                commit2 = (Commit)transition.getAction();
                action2 = transition2.getAction();
                if (action2 instanceof LD && commit2.getNbPossibleCommits() == 1 && !((LD)action2).bufferModified()) {
                    return true;
                }
                if (action2 instanceof LDDIFF && commit2.getNbPossibleCommits() == 1 && !((LDDIFF)action2).bufferModified()) {
                    return true;
                }
                if (!(action2 instanceof LD) && !(action2 instanceof LDDIFF)) {
                    throw new InternalError("must be load or loaddiff");
                }
            }
            if (n6 == 2 && n5 == 3 && (commit2 = (Commit)transition.getAction()).getNbPossibleCommits() == 1 && !((LDV)((Assign)transition2.getAction()).getExpression()).bufferModified()) {
                return true;
            }
            if (n5 == 2 && n6 == 3 && (commit2 = (Commit)transition2.getAction()).getNbPossibleCommits() == 1 && !((LDV)((Assign)transition2.getAction()).getExpression()).bufferModified()) {
                return true;
            }
            if (n5 == 3 && n6 == 3 && (n8 = ((Commit)transition.getAction()).getBufferStoreContent().getId()) != (n7 = ((Commit)transition2.getAction()).getBufferStoreContent().getId()) && n8 != Options.getNbGlobalVars() && n7 != Options.getNbGlobalVars()) {
                return true;
            }
            if (n5 == 13 && n6 == 3 && (transition.getAction().containsLoad() == -1 || ((Commit)transition2.getAction()).getNbPossibleCommits() == 1 && !((Expression)transition.getAction()).bufferModified())) {
                return true;
            }
            return n6 == 13 && n5 == 3 && (transition2.getAction().containsLoad() == -1 || ((Commit)transition.getAction()).getNbPossibleCommits() == 1 && !((Expression)transition2.getAction()).bufferModified());
        }
        if (n5 == 1 && n6 == 3) {
            commit = (Commit)transition2.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = transition.getAction();
            if (action instanceof LD && ((LD)action).containsLoadAt(n2)) {
                return false;
            }
            if (action instanceof LDDIFF && ((LDDIFF)action).containsLoadAt(n2)) {
                return false;
            }
            if (!(action instanceof LD) && !(action instanceof LDDIFF)) {
                throw new InternalError("must be load or loaddiff");
            }
        }
        if (n6 == 1 && n5 == 3) {
            commit = (Commit)transition.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = transition2.getAction();
            if (action instanceof LD && ((LD)action).containsLoadAt(n2)) {
                return false;
            }
            if (action instanceof LDDIFF && ((LDDIFF)action).containsLoadAt(n2)) {
                return false;
            }
            if (!(action instanceof LD) && !(action instanceof LDDIFF)) {
                throw new InternalError("must be load or loaddiff");
            }
        }
        if (n5 == 2 && n6 == 3) {
            commit = (Commit)transition2.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = (LDV)((Assign)transition.getAction()).getExpression();
            if (((LDV)action).containsLoadAt(n2)) {
                return false;
            }
        }
        if (n6 == 2 && n5 == 3) {
            commit = (Commit)transition.getAction();
            bufferStoreContent2 = commit.getBufferStoreContent();
            n2 = bufferStoreContent2.getId();
            action = (LDV)((Assign)transition2.getAction()).getExpression();
            if (((LDV)action).containsLoadAt(n2)) {
                return false;
            }
        }
        if (n6 == 3 && n5 == 3 && (n2 = (bufferStoreContent2 = (commit = (Commit)transition.getAction()).getBufferStoreContent()).getId()) == (n = (bufferStoreContent = ((Commit)(action = (Commit)transition2.getAction())).getBufferStoreContent()).getId()) && n2 != Options.getNbGlobalVars() && n != Options.getNbGlobalVars()) {
            return false;
        }
        if (n5 == 13 && n6 == 3) {
            int n9 = ((Commit)transition2.getAction()).getBufferStoreContent().getId();
            if (transition.getAction().containsLoadAt(n9) && n9 != Options.getNbGlobalVars()) {
                return false;
            }
        }
        if (n6 == 13 && n5 == 3) {
            int n10 = ((Commit)transition.getAction()).getBufferStoreContent().getId();
            if (transition2.getAction().containsLoadAt(n10) && n10 != Options.getNbGlobalVars()) {
                return false;
            }
        }
        if (!(n5 != 6 && n5 != 7 || n6 != 6 && n6 != 7 && n6 != 1 && n6 != 2 && n6 != 3)) {
            return false;
        }
        if (!(n6 != 6 && n6 != 7 || n5 != 6 && n5 != 7 && n5 != 1 && n5 != 2 && n5 != 3)) {
            return false;
        }
        if ((n5 == 6 || n5 == 7) && n6 == 13 && transition2.containsLoad() != -1) {
            return false;
        }
        return n6 != 6 && n6 != 7 || n5 != 13 || transition.containsLoad() == -1;
    }

    public boolean isDelayEmpty() {
        return this.delay.isEmpty();
    }

    public void addSetToDelaySet(HashSet<Transition> hashSet) {
        if (this.delay == null) {
            this.delay = new Vector();
        }
        Vector<Transition> vector = new Vector<Transition>();
        for (Transition transition : hashSet) {
            vector.add(transition);
        }
        this.delay.add(vector);
    }

    public int delaySetSize() {
        return this.delay.size();
    }

    public Vector<Transition> getAndRemoveDelaySet() {
        Vector<Transition> vector = this.delay.remove(0);
        return vector;
    }

    public void clearDelay() {
        this.delay.clear();
    }

    public int delaySize() {
        return this.delay.size();
    }

    @Override
    public Object clone() {
        int n;
        PsoState psoState = (PsoState)super.clone();
        psoState.cycleFlag = false;
        psoState.cycleProcess = -1;
        psoState.buffers = new Buffer[this.buffers.length];
        for (n = 0; n < this.buffers.length; ++n) {
            psoState.buffers[n] = (Buffer)this.buffers[n].clone();
        }
        if (this.sleepSet != null) {
            psoState.sleepSet = new HashSet();
            for (Transition transition : this.sleepSet) {
                psoState.sleepSet.add(transition);
            }
        }
        psoState.TSOlikeBuffer = new Buffer[this.TSOlikeBuffer.length];
        psoState.constructTSOBuffer = new boolean[this.constructTSOBuffer.length];
        for (n = 0; n < psoState.TSOlikeBuffer.length; ++n) {
            psoState.TSOlikeBuffer[n] = (Buffer)this.TSOlikeBuffer[n].clone();
            psoState.constructTSOBuffer[n] = this.constructTSOBuffer[n];
        }
        psoState.includedIn = new Vector();
        psoState.equalState = null;
        psoState.PSOrelaxation = false;
        return psoState;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof PsoState)) {
            return false;
        }
        PsoState psoState = (PsoState)object;
        if (this.buffers.length != psoState.buffers.length) {
            return false;
        }
        for (int i = 0; i < this.buffers.length; ++i) {
            if (this.buffers[i].equals(psoState.buffers[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.memory.hashCode() ^ Arrays.hashCode(this.processes) ^ Arrays.hashCode(this.buffers) ^ this.lock.hashCode();
        return n;
    }

    public boolean includes(PsoState psoState) {
        int n;
        if (!this.memory.equals(psoState.memory)) {
            return false;
        }
        for (n = 0; n < this.processes.length; ++n) {
            if (this.processes[n].equals(psoState.processes[n])) continue;
            return false;
        }
        for (n = 0; n < this.buffers.length; ++n) {
            if (psoState.buffers[n].isSubsetOf(this.buffers[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean computeErrorTraces() {
        boolean bl = false;
        this.errorTraceState = this.errorFlag;
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (!((PsoState)abstractState).computeErrorTraces()) continue;
                bl = true;
            }
        }
        if (this.stateType == 2 || this.stateType == 1 || this.stateType == 3) {
            if (this.equalState != null) {
                boolean bl2 = bl = bl || ((PsoState)this.equalState).errorTraceState;
            }
            if (!bl && this.includedIn != null) {
                for (AbstractState abstractState : this.includedIn) {
                    if (!((PsoState)abstractState).errorTraceState) continue;
                    bl = true;
                    break;
                }
            }
        }
        this.errorTraceState = bl || this.errorFlag;
        return this.errorTraceState;
    }

    @Override
    protected String dotNodeTextErrorTraces() {
        if (!this.errorTraceState) {
            return "";
        }
        String string = this.nbGlobalState + " [label=\"" + this.text + "\"";
        if (this.stateType == 2 || this.stateType == 3 || this.stateType == 1) {
            string = string + ",shape=box";
        }
        if (this.errorFlag) {
            string = string + ",style=filled,color=red";
        }
        string = string + "];\n";
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                if (!((PsoState)abstractState).errorTraceState) continue;
                string = string + this.nbGlobalState + " -> " + abstractState.getGlobalStateNb();
                if (((PsoState)abstractState).tFollowed != null) {
                    string = string + " [label = \"" + ((PsoState)abstractState).tFollowed.getLabelGlobalDot() + "\"]";
                }
                string = string + "\n";
                string = string + ((PsoState)abstractState).dotNodeTextErrorTraces();
            }
        }
        return string;
    }

    @Override
    public int setStateNumbersAntText(int n, boolean bl) {
        int n2;
        this.nbGlobalState = n++;
        this.text = this.nbGlobalState + ": (";
        for (n2 = 0; n2 < this.processes.length; ++n2) {
            this.text = this.text + this.processes[n2].getControlLocation();
            this.text = this.text + ",";
        }
        this.text = this.text + this.memory.printMemory() + ")";
        if (this.cycleFlag) {
            this.text = this.text + " process " + this.cycleProcess + ": cycle found -> " + this.cycleFrom.getGlobalStateNb();
        }
        if (this.stateType == 2 || this.stateType == 3) {
            this.text = this.text + " -- eq: " + this.equalState.getGlobalStateNb();
        }
        if (this.stateType == 1 || this.stateType == 3) {
            this.text = this.text + " -- incl in: ";
            for (n2 = 0; n2 < this.includedIn.size(); ++n2) {
                AbstractState abstractState = this.includedIn.elementAt(n2);
                this.text = this.text + abstractState.getGlobalStateNb();
                if (n2 >= this.includedIn.size() - 1) continue;
                this.text = this.text + ",";
            }
        }
        if (this.succ != null) {
            for (AbstractState abstractState : this.succ) {
                n = abstractState.setStateNumbersAntText(n, bl);
            }
        }
        if (bl) {
            int n3 = this.controlGraphs.getGlobalVariableNumber();
            for (int i = 0; i < this.processes.length; ++i) {
                String string = this.nbGlobalState + "_" + i;
                for (int j = 0; j < n3; ++j) {
                    this.buffers[i * n3 + j].printBuffer(string + "_" + j);
                }
                this.TSOlikeBuffer[i].printBuffer(string + "_TSOlike");
            }
        }
        return n;
    }

    public Transition searchLastRelaxation(ControlGraphs controlGraphs) throws NoRelaxationException {
        if (this.PSOrelaxation) {
            if (this.tFollowed.getType() != 3) {
                throw new InternalError("PSO relaxation must have come from a commit");
            }
            Commit commit = (Commit)this.tFollowed.getAction();
            BufferStoreContent bufferStoreContent = commit.getBufferStoreContent();
            return bufferStoreContent.getTransition();
        }
        if (this.pred != null) {
            return ((PsoState)this.pred).searchLastRelaxation(controlGraphs);
        }
        throw new NoRelaxationException();
    }

    public Transition searchLastStoreLoadRelaxation(ControlGraphs controlGraphs) {
        if (this.operationType == 1 || this.operationType == 2) {
            boolean bl = true;
            int n = this.controlGraphs.getGlobalVariableNumber();
            int n2 = this.advancedProcess;
            for (int i = n2 * n; i < (n2 + 1) * n; ++i) {
                Buffer buffer = this.buffers[i];
                if (buffer.isEmptyString()) continue;
                bl = false;
                break;
            }
            if (!bl) {
                return this.getStoreBeforeLoad();
            }
        } else {
            if (this.tFollowed == null) {
                return null;
            }
            Action action = this.tFollowed.getAction();
            if (this.operationType == 13 && action.containsLoad() != -1) {
                boolean bl = true;
                int n = this.controlGraphs.getGlobalVariableNumber();
                int n3 = this.advancedProcess;
                for (int i = n3 * n; i < (n3 + 1) * n; ++i) {
                    Buffer buffer = this.buffers[i];
                    if (buffer.isEmptyString()) continue;
                    bl = false;
                    break;
                }
                if (!bl) {
                    return this.getStoreBeforeLoad();
                }
            }
        }
        return null;
    }

    public Transition searchLastStoreStoreRelaxation(ControlGraphs controlGraphs) {
        if (this.operationType == 3) {
            int n = this.advancedProcess;
            Commit commit = (Commit)this.tFollowed.getAction();
            BufferStoreContent bufferStoreContent = commit.getBufferStoreContent();
            int n2 = bufferStoreContent.getId();
            Transition transition = bufferStoreContent.getTransition();
            PsoState psoState = this.getEarlyStoreState(n, n2);
            if (psoState == null) {
                return null;
            }
            Commit commit2 = (Commit)psoState.tFollowed.getAction();
            Transition transition2 = commit2.getBufferStoreContent().getTransition();
            if (!this.newCheck4Order(this, transition2, transition, n)) {
                return transition;
            }
        }
        return null;
    }

    private Transition getStoreBeforeLoad() {
        PsoState psoState = this;
        while (psoState.pred != null) {
            psoState = (PsoState)psoState.pred;
            if (psoState.getAdvancedProc() != this.advancedProcess || psoState.getOperationType() != 0) continue;
            return psoState.tFollowed;
        }
        throw new InternalError("must find a store operation before the load");
    }

    private PsoState getEarlyStoreState(int n, int n2) {
        PsoState psoState = this;
        PsoState psoState2 = (PsoState)psoState.pred;
        while (psoState2 != null) {
            if (psoState2.operationType == 3) {
                Commit commit = (Commit)psoState2.tFollowed.getAction();
                if (psoState2.advancedProcess == n && commit.getBufferStoreContent().getId() != n2) {
                    return psoState2;
                }
            }
            psoState2 = (PsoState)psoState2.pred;
        }
        return null;
    }

    private boolean newCheck4Order(PsoState psoState, Transition transition, Transition transition2, int n) {
        if (psoState == null) {
            return false;
        }
        if (psoState.advancedProcess != n) {
            return this.newCheck4Order((PsoState)psoState.pred, transition, transition2, n);
        }
        if (psoState.tFollowed.getType() != 0) {
            return this.newCheck4Order((PsoState)psoState.pred, transition, transition2, n);
        }
        if (psoState.tFollowed.getType() == 4) {
            return false;
        }
        return psoState.tFollowed.equals(transition2);
    }

    private Buffer emptyBuffer() {
        return new Buffer();
    }

    @Override
    protected void printCurrentTrace() {
        int n;
        String string;
        int n2;
        String string2;
        int n3 = this.controlGraphs.getGlobalVariableNumber();
        String string3 = new String();
        string3 = "digraph Global {\n";
        string3 = string3 + "initial -> 0\n";
        string3 = string3 + "initial [shape=plaintext, label=\"\"];\n";
        int n4 = 2;
        PsoState psoState = this;
        Vector<String> vector = new Vector<String>();
        while (psoState != null && psoState.pred != null) {
            string2 = new String();
            string2 = string2 + n4 + " -> " + (n4 - 1) + " [label= \"" + psoState.tFollowed.getLabelGlobalDot() + "\"]\n";
            string2 = string2 + (n4 - 1) + " [label= \"(";
            for (n2 = 0; n2 < this.processes.length; ++n2) {
                string2 = string2 + psoState.processes[n2].getControlLocation();
                string2 = string2 + ",";
            }
            string2 = string2 + psoState.memory.printMemory() + ")\"];\n";
            for (n2 = 0; n2 < this.processes.length; ++n2) {
                string = n4 + "_" + n2;
                for (n = 0; n < n3; ++n) {
                    psoState.buffers[n2 * n3 + n].printBuffer(string + "_" + n);
                }
                psoState.TSOlikeBuffer[n2].printBuffer(string + "_TSOlike");
            }
            ++n4;
            psoState = (PsoState)psoState.pred;
            vector.add(string2);
        }
        string2 = "0->" + (n4 - 1) + "\n";
        string2 = string2 + (n4 - 1) + " [label= \"(";
        for (n2 = 0; n2 < this.processes.length; ++n2) {
            string2 = string2 + psoState.processes[n2].getControlLocation();
            string2 = string2 + ",";
        }
        string2 = string2 + psoState.memory.printMemory() + ")\"];\n";
        vector.add(string2);
        for (n2 = 0; n2 < this.processes.length; ++n2) {
            string = "0_" + n2;
            for (n = 0; n < n3; ++n) {
                psoState.buffers[n2 * n3 + n].printBuffer(string + "_" + n);
            }
            psoState.TSOlikeBuffer[n2].printBuffer(string + "_TSOlike");
        }
        for (n2 = vector.size() - 1; n2 >= 0; --n2) {
            string3 = string3 + (String)vector.elementAt(n2);
        }
        string3 = string3 + "}";
        String string4 = Constants.TEMP_DIR + "/" + "Remmex" + "/";
        string = string4 + "current_trace.dot";
        String string5 = string4 + "current_trace.pdf";
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string3);
            fileWriter.close();
            String string6 = "dot -Tpdf " + string + " -o " + string5;
            Runtime.getRuntime().exec(string6);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        string3 = string3 + "}";
    }

    public boolean check4Deadlock(ControlGraphs controlGraphs) throws SuffixException {
        for (Buffer cloneable : this.buffers) {
            if (cloneable.acceptsEmptyString()) continue;
            return false;
        }
        Vector<TransitionAndSuccessor> vector = this.computeEnabled(controlGraphs);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = (TransitionAndSuccessor)iterator.next();
            Transition transition = transitionAndSuccessor.getTransition();
            if (transition.getType() == 3) continue;
            return false;
        }
        this.deadlockFlag = true;
        this.nbDeadlock = ++AbstractState.countDeadlocks;
        return true;
    }

    public boolean isDeadlockState() {
        return this.deadlockFlag;
    }

    public boolean check4Deadlock(Vector<TransitionAndSuccessor> vector) {
        for (Buffer cloneable : this.buffers) {
            if (cloneable.acceptsEmptyString()) continue;
            return false;
        }
        boolean bl = false;
        for (TransitionAndSuccessor transitionAndSuccessor : vector) {
            Transition transition = transitionAndSuccessor.getTransition();
            if (transition.getType() == 3) continue;
            if (transitionAndSuccessor.getAbstractState() != null) {
                return false;
            }
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.deadlockFlag = true;
        this.nbDeadlock = ++AbstractState.countDeadlocks;
        return true;
    }

    private boolean restartTSOBufferConstruction(int n) {
        for (Buffer buffer : this.buffers) {
            if (buffer.isEmptyString()) continue;
            return false;
        }
        return true;
    }
}

