/*
 * Decompiled with CFR 0.152.
 */
package modelchecker.tso;

import buffer.Buffer;
import buffer.BufferContent;
import controlgraph.ControlGraphs;
import controlgraph.Transition;
import exceptions.MfenceException;
import exceptions.NoRelaxationException;
import exceptions.SuffixException;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import modelchecker.AbstractState;
import modelchecker.Explorer;
import modelchecker.Memory;
import modelchecker.MyHashSet;
import modelchecker.MyStack;
import modelchecker.Process;
import modelchecker.TransitionAndSuccessor;
import modelchecker.tso.StateStaticParts;
import modelchecker.tso.TsoState;
import options.Options;

public class TsoExplorer
extends Explorer {
    private StateStaticParts sSPs;

    public TsoExplorer(ControlGraphs controlGraphs, Vector<Vector<Integer>> vector) {
        super(vector);
        this.controlGraphs = controlGraphs;
        this.stack = new MyStack();
        this.sSPs = new StateStaticParts();
        this.hashTable = new MyHashSet();
        this.initExploration();
    }

    public void initExploration() {
        Memory memory = this.controlGraphs.initMemory();
        Process[] processArray = this.controlGraphs.initProcesses();
        Buffer[] bufferArray = this.controlGraphs.initBuffer(1);
        this.initialState = new TsoState(null, memory, processArray, bufferArray);
        this.stack.push(this.initialState);
    }

    @Override
    public synchronized void storeState(AbstractState abstractState) {
        ++this.nbStatesStored;
        this.hashTable.add(abstractState);
        this.sSPs.addState((TsoState)abstractState);
    }

    @Override
    public synchronized boolean contains(AbstractState abstractState) {
        return this.hashTable.contains(abstractState);
    }

    @Override
    public synchronized AbstractState visited(AbstractState abstractState) {
        if (this.hashTable.contains(abstractState)) {
            return this.hashTable.get(abstractState);
        }
        return null;
    }

    public synchronized Vector<AbstractState> included(AbstractState abstractState) {
        return this.sSPs.included((TsoState)abstractState);
    }

    @Override
    public void removeState(AbstractState abstractState) {
        this.hashTable.remove(abstractState);
        this.sSPs.removeState((TsoState)abstractState);
        --this.nbStatesStored;
    }

    public synchronized boolean includedIn(AbstractState abstractState) {
        return this.sSPs.included((TsoState)abstractState) != null;
    }

    private TsoState getStateOnStack(TsoState tsoState) {
        int n = this.stack.indexOf(tsoState);
        return (TsoState)this.stack.elementAt(n);
    }

    public int getNbStates() {
        return this.hashTable.size();
    }

    @Override
    protected void DFS() throws MfenceException, SuffixException, NoRelaxationException, Exception {
        Object object;
        TsoState tsoState = (TsoState)this.stack.peek();
        AbstractState abstractState = null;
        Vector<AbstractState> vector = null;
        Vector<TransitionAndSuccessor> vector2 = null;
        HashSet<Transition> hashSet = null;
        this.printInfo();
        abstractState = this.visited(tsoState);
        vector = this.included(tsoState);
        if (abstractState != null || vector != null) {
            if (abstractState != null) {
                hashSet = new HashSet<Transition>();
                hashSet.addAll(abstractState.getSleepSet());
                if (abstractState != tsoState && !tsoState.getFromDelayFlag()) {
                    tsoState.setEqualState(abstractState);
                    tsoState.setStateType(2);
                }
            }
            if (vector != null) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashSet.addAll(vector.elementAt(0).getSleepSet());
                }
                for (AbstractState object22 : vector) {
                    hashSet.retainAll(object22.getSleepSet());
                }
                tsoState.setIncludingVector(vector);
                if (abstractState == null) {
                    tsoState.setStateType(1);
                } else {
                    tsoState.setStateType(3);
                }
            }
            object = new Vector();
            ((Vector)object).addAll(hashSet);
            ((Vector)object).removeAll(tsoState.getSleepSet());
            this.sort((Vector<Transition>)object);
            vector2 = tsoState.computeT(this.controlGraphs, (Vector<Transition>)object);
        } else {
            tsoState.setStateType(0);
            vector2 = tsoState.computeT(this.controlGraphs);
            object = vector2.iterator();
            while (object.hasNext()) {
                Transition transition = object.next().getTransition();
                if (!tsoState.getSleepSet().contains(transition)) continue;
                object.remove();
            }
        }
        if (Options.getProperty() == 0 && Options.getExplorationMode() == 2 || Options.getExplorationMode() == 0) {
            this.sort2KeepPartialErrorState(tsoState, vector2);
        }
        if (!tsoState.getFromDelayFlag()) {
            if (Options.getProperty() == 0 && tsoState.isErrorState()) {
                if (Options.getExplorationMode() == 0) {
                    throw new Exception("First Error");
                }
                if (Options.getExplorationMode() == 2) {
                    object = tsoState.searchLastRelaxation();
                    Transition transition = ((Transition)object).getControlGraph().putMfence((Transition)object);
                    Explorer.addInsertedFence(transition);
                    throw new MfenceException();
                }
            } else if (Options.getProperty() == 1 && tsoState.isDeadlockState()) {
                if (Options.getExplorationMode() == 0) {
                    throw new Exception("First Error");
                }
                if (Options.getExplorationMode() == 2) {
                    object = tsoState.searchLastRelaxation();
                    Transition transition = ((Transition)object).getControlGraph().putMfence((Transition)object);
                    Explorer.addInsertedFence(transition);
                    throw new MfenceException();
                }
            }
        }
        if (abstractState == null) {
            this.storeState(tsoState);
        } else {
            tsoState.setEqualState(abstractState);
            tsoState.getSleepSet().retainAll(hashSet);
            abstractState.getSleepSet().clear();
            abstractState.getSleepSet().addAll(tsoState.getSleepSet());
            if (vector != null) {
                for (AbstractState abstractState2 : vector) {
                    abstractState2.getSleepSet().clear();
                    abstractState2.getSleepSet().addAll(tsoState.getSleepSet());
                }
            }
        }
        ++this.nbStatesVisited;
        object = new HashSet<Transition>();
        ((AbstractCollection)object).addAll(tsoState.getSleepSet());
        for (TransitionAndSuccessor transitionAndSuccessor : vector2) {
            Transition transition = transitionAndSuccessor.getTransition();
            TsoState tsoState2 = (TsoState)transitionAndSuccessor.getAbstractState();
            tsoState2.updateSleepSetIndependence(transition, (HashSet<Transition>)object);
            this.currDepth = this.stack.size();
            if (this.stack.contains(tsoState2)) {
                TsoState tsoState3 = this.getStateOnStack(tsoState2);
                if (!tsoState3.equals(tsoState2)) {
                    System.out.println("also not possible");
                }
                tsoState3.addSetToDelaySet(tsoState2.getSleepSet());
            } else {
                if (transition.getType() == 3) {
                    this.incrementCommitCounter();
                } else {
                    this.incrementOtherOpsCounter();
                }
                tsoState2.clearDelay();
                tsoState.addSuccessor(tsoState2);
                this.stack.push(tsoState2);
                if (this.maxDepth < this.currDepth) {
                    this.maxDepth = this.currDepth;
                }
                this.DFS();
            }
            ((HashSet)object).add(transition);
        }
        tsoState = (TsoState)this.stack.pop();
        if (tsoState.delaySetSize() > 0) {
            tsoState.getSleepSet().clear();
            tsoState.getSleepSet().addAll(tsoState.getAndRemoveDelaySet());
            tsoState.setFromDelayFlag(true);
            this.stack.push(tsoState);
            this.DFS();
        }
    }

    private void sort(Vector<Transition> vector) {
        int n;
        Transition[] transitionArray = new Transition[vector.size()];
        vector.toArray(transitionArray);
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < transitionArray.length; ++n) {
            if (transitionArray[n].getType() != 3) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        n3 = n2 + 1;
        block1: while (n3 < transitionArray.length) {
            Transition transition;
            if (transitionArray[n3].getType() == 3) {
                ++n3;
                continue;
            }
            Transition transition2 = transitionArray[n2];
            transitionArray[n2] = transition = transitionArray[n3];
            transitionArray[n3] = transition2;
            ++n2;
            ++n3;
            while (n2 < transitionArray.length) {
                if (transitionArray[n2].getType() == 3) {
                    n3 = n2 >= n3 ? n2 + 1 : n3 + 1;
                    continue block1;
                }
                if (n2 < transitionArray.length) {
                    ++n2;
                    continue;
                }
                ++n2;
                n3 = transitionArray.length;
            }
        }
        vector.clear();
        for (n = 0; n < transitionArray.length; ++n) {
            vector.add(transitionArray[n]);
        }
    }

    private void sort2KeepPartialErrorState(TsoState tsoState, Vector<TransitionAndSuccessor> vector) {
        Vector<TransitionAndSuccessor> vector2 = new Vector<TransitionAndSuccessor>();
        TsoState tsoState2 = tsoState;
        Iterator<TransitionAndSuccessor> iterator = vector.iterator();
        while (iterator.hasNext()) {
            TransitionAndSuccessor transitionAndSuccessor = iterator.next();
            if (transitionAndSuccessor.getTransition().getType() == 3 || !TsoExplorer.isPartialErrorStateProcess(tsoState2, transitionAndSuccessor.getTransition().getNbProcess())) continue;
            vector2.add(transitionAndSuccessor);
            iterator.remove();
        }
        for (TransitionAndSuccessor transitionAndSuccessor : vector2) {
            vector.add(transitionAndSuccessor);
        }
    }

    @Override
    public void finish() {
        if (Options.getVerbose()) {
            this.printStoreBufferContents();
        }
        if (Options.getPrintGlobalStateSpace() || Options.getPrintErrorTraces() || Options.getPrintStateBuffers()) {
            this.printStates();
        }
        if (Options.getPrintErrorTraces() || Options.getExplorationMode() == 0) {
            this.initialState.printErrorTraces();
        }
    }

    public void printStates() {
        this.initialState.setStateNumbersAntText(0, Options.getPrintStateBuffers());
        if (Options.getPrintGlobalStateSpace()) {
            this.initialState.globalDot();
        }
    }

    public void printStoreBufferContents() {
        BufferContent.printBufferContents();
    }
}

