/*
 * Decompiled with CFR 0.152.
 */
package options;

import java.util.Vector;
import options.Constants;

public class Options {
    private static String DOT = null;
    private static Constants.Platform os = null;
    private static int memoryModel = 1;
    private static int property = 0;
    private static Vector<Vector<Integer>> errorStates = new Vector();
    private static int explorationMode = 2;
    private static String fileName = null;
    private static boolean verbose = false;
    private static boolean printGlobalStateSpace = false;
    private static boolean printErrorTraces = false;
    private static boolean printStateBuffers = false;
    private static boolean maximalPermissive = false;
    private static int nbGlobalVars = Integer.MAX_VALUE;

    public static void setMaximalPermissive(boolean bl) {
        maximalPermissive = bl;
    }

    public static boolean getMaximalPermissive() {
        return maximalPermissive;
    }

    public static void setNbGlobalVars(int n) {
        nbGlobalVars = n;
    }

    public static int getNbGlobalVars() {
        return nbGlobalVars;
    }

    public static void setMemoryModel(int n) {
        memoryModel = n;
    }

    public static boolean setMemoryModel(String string) {
        if (string.equals("SC")) {
            memoryModel = 0;
        } else if (string.equals("TSO")) {
            memoryModel = 1;
        } else if (string.equals("PSO")) {
            memoryModel = 2;
        } else {
            return false;
        }
        return true;
    }

    public static void setProperty(int n) {
        property = n;
    }

    public static boolean setProperty(String string) {
        if (string.equals("safety")) {
            property = 0;
        } else if (string.equals("deadlock")) {
            property = 1;
        } else if (string.equals("controlgraphs")) {
            property = 2;
        } else {
            return false;
        }
        return true;
    }

    public static void resetErrorStates() {
        errorStates.clear();
    }

    public static void addErrorState(Vector<Integer> vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        for (Integer n : vector) {
            vector2.add(new Integer(n));
        }
        errorStates.add(vector2);
    }

    public static void setExplorationMode(int n) {
        explorationMode = n;
    }

    public static boolean setExplorationMode(String string) {
        if (string.equals("firstError")) {
            explorationMode = 0;
        } else if (string.equals("allErrors")) {
            explorationMode = 1;
        } else if (string.equals("errorCorrection")) {
            explorationMode = 2;
        } else if (string.equals("stateSpace")) {
            explorationMode = 3;
        } else {
            return false;
        }
        return true;
    }

    public static void setFileName(String string) {
        fileName = new String(string);
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setPrintGlobalStateSpace(boolean bl) {
        printGlobalStateSpace = bl;
    }

    public static void setPrintErrorTraces(boolean bl) {
        printErrorTraces = bl;
    }

    public static void setPrintStateBuffers(boolean bl) {
        printStateBuffers = bl;
    }

    public static int getMemoryModel() {
        return memoryModel;
    }

    public static int getProperty() {
        return property;
    }

    public static Vector<Vector<Integer>> getErrorStates() {
        Vector<Vector<Integer>> vector = new Vector<Vector<Integer>>();
        for (Vector<Integer> vector2 : errorStates) {
            Vector<Integer> vector3 = new Vector<Integer>();
            for (Integer n : vector2) {
                vector3.add(new Integer(n));
            }
            vector.add(vector3);
        }
        return vector;
    }

    public static int getExplorationMode() {
        return explorationMode;
    }

    public static String getFileName() {
        if (fileName == null) {
            return null;
        }
        return new String(fileName);
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static boolean getPrintGlobalStateSpace() {
        return printGlobalStateSpace;
    }

    public static boolean getPrintErrorTraces() {
        return printErrorTraces;
    }

    public static boolean getPrintStateBuffers() {
        return printStateBuffers;
    }

    public static void printOptions() {
        String string = null;
        Options.print("Options:");
        switch (memoryModel) {
            case 0: {
                string = "SC";
                break;
            }
            case 1: {
                string = "TSO";
                break;
            }
            case 2: {
                string = "PSO";
            }
        }
        Options.print("    Memory Model: " + string);
        switch (property) {
            case 2: {
                string = "Controlgraph";
                break;
            }
            case 0: {
                string = "Safety";
                break;
            }
            case 1: {
                string = "Deadlock";
            }
        }
        Options.print("    Property checked: " + string);
        string = new String();
        for (Vector<Integer> vector : errorStates) {
            string = string + "\n    ( ";
            for (Integer n : vector) {
                string = string + n + " ";
            }
            string = string + ")\n";
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        Options.print("    Error states:" + string);
        switch (explorationMode) {
            case 3: {
                string = "State space";
                break;
            }
            case 0: {
                string = "First error";
                break;
            }
            case 1: {
                string = "All errors";
                break;
            }
            case 2: {
                string = "Error correction";
            }
        }
        Options.print("    Exploration mode: " + string);
        Options.print("    Verbose: " + verbose);
        Options.print("    Print global state space: " + printGlobalStateSpace);
        Options.print("    Print error traces: " + printErrorTraces);
        Options.print("    Print state buffers: " + printStateBuffers);
        Options.print("");
    }

    private static void print(String string) {
        System.out.println(string);
    }

    public static Constants.Platform getOS() {
        if (os == null) {
            os = Constants.OS_NAME.contains("win") ? Constants.Platform.Windows : (Constants.OS_NAME.contains("unix") || Constants.OS_NAME.contains("linux") ? Constants.Platform.Unix : Constants.Platform.unsupported);
        }
        return os;
    }

    public static String getDotCommand() {
        if (DOT == null) {
            switch (Options.getOS()) {
                case Unix: {
                    DOT = "dot";
                    break;
                }
                case Windows: {
                    DOT = "dot.exe";
                    break;
                }
                default: {
                    DOT = "dot";
                }
            }
        }
        return DOT;
    }
}

