/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#include "AxisAlignedBoundingBox.h"
#include <limits>

AxisAlignedBoundingBox :: AxisAlignedBoundingBox () {
	minX = std :: numeric_limits < int > :: max () ;
	maxX = std :: numeric_limits < int > :: min () ;
	minY = std :: numeric_limits < int > :: max () ;
	maxY = std :: numeric_limits < int > :: min () ;
}

AxisAlignedBoundingBox :: AxisAlignedBoundingBox ( int minX , int maxX , int minY , int maxY ) {
	this -> minX = minX ;
	this -> maxX = maxX ;
	this -> minY = minY ;
	this -> maxY = maxY ;
}

AxisAlignedBoundingBox :: ~ AxisAlignedBoundingBox () {}

bool AxisAlignedBoundingBox :: isEmpty () const {
	return minX > maxX || minY > maxY ;
}

int AxisAlignedBoundingBox :: getMinX () const {
	return minX ;
}

int AxisAlignedBoundingBox :: getMaxX () const {
	return maxX ;
}

int AxisAlignedBoundingBox :: getMinY () const {
	return minY ;
}

int AxisAlignedBoundingBox :: getMaxY () const {
	return maxY ;
}

static inline int min ( int a , int b ) {
	return ( a < b ) ? a : b ;
}

static inline int max ( int a , int b ) {
	return ( a > b ) ? a : b ;
}

void AxisAlignedBoundingBox :: extendToIncludePoint ( int x , int y ) {
	minX = min ( minX , x ) ;
	maxX = max ( maxX , x ) ;
	minY = min ( minY , y ) ;
	maxY = max ( maxY , y ) ;
}

void AxisAlignedBoundingBox :: extendToIncludeAABB ( const AxisAlignedBoundingBox & aabb ) {
	minX = min ( minX , aabb.minX ) ;
	maxX = max ( maxX , aabb.maxX ) ;
	minY = min ( minY , aabb.minY ) ;
	maxY = max ( maxY , aabb.maxY ) ;
}

bool AxisAlignedBoundingBox :: equals ( const AxisAlignedBoundingBox & aabb1 , const AxisAlignedBoundingBox & aabb2 ) {
	if ( aabb1.isEmpty () && aabb2.isEmpty () ) return true ;
	if ( aabb1.minX != aabb2.minX ) return false ;
	if ( aabb1.maxX != aabb2.maxX ) return false ;
	if ( aabb1.minY != aabb2.minY ) return false ;
	if ( aabb1.maxY != aabb2.maxY ) return false ;
	return true ;

}
