/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __GRANU_H__
#define __GRANU_H__

#include <vector>
#include "Rectangle.h"
#include "Volume2D.h"

class Granu {

private :

	Granu () {}
	virtual ~ Granu () {}

public :

	class Callback {
	protected :
		Callback () {}
		virtual ~ Callback () {}
	public :
		virtual void largestIncludedRectangleFound ( const Rectangle & rectangle ) const = 0 ;
	} ;

	static void findLargestIncludedRectangles ( const Volume2D & volume , const Callback & callback ) ;
	static void addLargestIncludedRectangles ( const Volume2D & volume , std::vector < Rectangle > & listing ) ;

	static bool checkLargestIncludedRectangles ( const Volume2D & volume , const std::vector < Rectangle > & listing ) ;

} ;

#endif
