/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __RECTANGLE_H__
#define __RECTANGLE_H__

#include <ostream>

#include "Volume2D.h"

class Rectangle : public Volume2D {

private :

	int minX ;
	int maxX ;
	int minY ;
	int maxY ;

	friend std :: ostream & operator << ( std :: ostream & s , const Rectangle & r ) {
		return s << "Rectangle [ " << r.minX << " , " << r.maxX << " ] x [ " << r.minY << " , " << r.maxY << "] ( area = " << r.getArea() << " )" ;
	}

public :

	Rectangle ( int minX , int maxX , int minY , int maxY ) ;

	int getMinX () const ;
	int getMaxX () const ;
	int getMinY () const ;
	int getMaxY () const ;

	static bool equals ( const Rectangle & r1 , const Rectangle & r2 ) ;

	bool isPointInside ( int x , int y ) const ;

	AxisAlignedBoundingBox getBoundingBox () const ;

	bool isIncludedIn ( const Volume2D & v ) const ;

	int getWidth () const ;
	int getHeight () const ;
	int getArea () const ;

	virtual ~ Rectangle () ;

} ;

#endif
