/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#include <stdexcept>
#include "Rectangle.h"

Rectangle :: Rectangle ( int minX , int maxX , int minY , int maxY ) {
	if ( maxX < minX ) throw std::invalid_argument ( "maxX < minX" ) ;
	if ( maxY < minY ) throw std::invalid_argument ( "maxY < minY" ) ;
	this -> minX = minX ;
	this -> maxX = maxX ;
	this -> minY = minY ;
	this -> maxY = maxY ;
}

int Rectangle :: getMinX () const {
	return minX ;
}

int Rectangle :: getMaxX () const {
	return maxX ;
}

int Rectangle :: getMinY () const {
	return minY ;
}

int Rectangle :: getMaxY () const {
	return maxY ;
}

bool Rectangle :: equals ( const Rectangle & r1 , const Rectangle & r2 ) {

	if ( r1.minX != r2.minX ) return false ;
	if ( r1.maxX != r2.maxX ) return false ;
	if ( r1.minY != r2.minY ) return false ;
	if ( r1.maxY != r2.maxY ) return false ;
	return true ;

}

bool Rectangle :: isPointInside ( int x , int y ) const {
	if ( ( x < minX ) | ( x > maxX ) ) return false ;
	if ( ( y < minY ) | ( y > maxY ) ) return false ;
	return true ;
}

AxisAlignedBoundingBox Rectangle :: getBoundingBox () const {
	AxisAlignedBoundingBox aabb ;
	aabb.extendToIncludePoint ( minX , minY ) ;
	aabb.extendToIncludePoint ( maxX , maxY ) ;
	return aabb ;
}

bool Rectangle :: isIncludedIn ( const Volume2D & v ) const {
	AxisAlignedBoundingBox aabb = v.getBoundingBox () ;
	if ( aabb.getMinX () > minX ) return false ;
	if ( aabb.getMaxX () < maxX ) return false ;
	if ( aabb.getMinY () > minY ) return false ;
	if ( aabb.getMaxY () < maxY ) return false ;
	for ( int x = minX ; x <= maxX ; ++ x ) {
		for ( int y = minY ; y <= maxY ; ++ y ) {
			if ( ! v.isPointInside ( x , y ) ) return false ;
		}
	}
	return true ;
}

int Rectangle :: getWidth () const {
	return maxX - minX + 1 ;
}
int Rectangle :: getHeight () const {
	return maxY - minY + 1 ;
}
int Rectangle :: getArea () const {
	return getWidth () * getHeight () ;
}

Rectangle :: ~ Rectangle () {}
