/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#include <iostream>
#include <stdlib.h>
#include <vector>

#include "Granu.h"
#include "Volume2D.h"
#include "Rectangle.h"
#include "GrayscaleImage.h"

using namespace std ;

int main ( int argc , char * argv [] ) {

	{ // this block is needed to avoid memory leak when calling exit
	  // because otherwise RAII would be unused.

		if ( argc != 2 ) {
			cout << "USAGE : " << argv [ 0 ] << " <jpg-image-file>" << endl ;
			exit ( EXIT_FAILURE ) ;
		}

		cout << "****************************************************************************************" << endl ;
		cout << "*  IMPORTANT NOTE. This program was written with the primary objective of the source   *" << endl ;
		cout << "*  code readability. It has not been optimized. Thus, this program should not be used  *" << endl ;
		cout << "*  to measure the performance of the algorithm it demonstrates.                        *" << endl ;
		cout << "****************************************************************************************" << endl ;

		GrayscaleImage img ( argv [ 1 ] ) ;
		Volume2D * volume = Volume2D :: createVolumeFromImage ( img ) ;
		vector < Rectangle > listing ;
		Granu :: addLargestIncludedRectangles ( * volume , listing ) ;
		for ( vector < Rectangle > :: iterator r = listing.begin () ; r != listing.end () ; ++ r ) {
			cout << * r << endl ;
		}
		Granu :: checkLargestIncludedRectangles ( * volume , listing ) ;
		delete volume ;

	}

	exit ( EXIT_SUCCESS ) ;

}

