/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#include <cmath>
#include <stdexcept>
#include <cstring>

#include "Rectangle.h"
#include "RectangleMeasure.h"

class RectangleMeasure_Width : public RectangleMeasure {
public :
	double operator () ( Rectangle r ) const {
		return ( double ) r.getWidth () ;
	}
} ;

class RectangleMeasure_Height : public RectangleMeasure {
	double operator () ( Rectangle r ) const {
		return ( double ) r.getHeight () ;
	}
} ;

class RectangleMeasure_Area : public RectangleMeasure {
	double operator () ( Rectangle r ) const {
		return ( double ) r.getArea () ;
	}
} ;

class RectangleMeasure_Diagonal : public RectangleMeasure {
	double operator () ( Rectangle r ) const {
		return sqrt ( ( double ) ( r.getWidth () * r.getWidth () + r.getHeight () * r.getHeight () ) ) ;
	}
} ;

class RectangleMeasure_CenterX : public RectangleMeasure {
	double operator () ( Rectangle r ) const {
		return 0.5f * ( r.getMinX () + r.getMaxX () ) ;
	}
} ;

class RectangleMeasure_CenterY : public RectangleMeasure {
	double operator () ( Rectangle r ) const {
		return 0.5f * ( r.getMinY () + r.getMaxY () ) ;
	}
} ;

RectangleMeasure * RectangleMeasure :: getMeasureByName ( char * name ) {
	if ( 0 == strcmp ( "WIDTH"    , name ) ) return new RectangleMeasure_Width () ;
	if ( 0 == strcmp ( "HEIGHT"   , name ) ) return new RectangleMeasure_Height () ;
	if ( 0 == strcmp ( "AREA"     , name ) ) return new RectangleMeasure_Area () ;
	if ( 0 == strcmp ( "DIAGONAL" , name ) ) return new RectangleMeasure_Diagonal () ;
	if ( 0 == strcmp ( "CENTER-X" , name ) ) return new RectangleMeasure_CenterX () ;
	if ( 0 == strcmp ( "CENTER-Y" , name ) ) return new RectangleMeasure_CenterY () ;
	throw std::invalid_argument ( "unknown measure name" ) ;
}
