/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __VOLUME_2D_H__
#define __VOLUME_2D_H__

#include <vector>

#include "GrayscaleImage.h"
#include "AxisAlignedBoundingBox.h"

class Volume2D {
	
	public :
	
	static Volume2D * createVolumeFromImage ( const GrayscaleImage & img ) ;
	static Volume2D * createHollowSphere ( int internalRadius , int externalRadius ) ;
	static Volume2D * createUnion ( const std::vector < const Volume2D * > & listing ) ;
	
	virtual bool isPointInside ( int x , int y ) const = 0 ;
	virtual AxisAlignedBoundingBox getBoundingBox () const = 0 ;
	
	bool isPointOnBoundaryInfX ( int x , int y ) const ;
	bool isPointOnBoundarySupX ( int x , int y ) const ;
	bool isPointOnBoundaryInfY ( int x , int y ) const ;
	bool isPointOnBoundarySupY ( int x , int y ) const ;

	static bool equals ( const Volume2D & v1 , const Volume2D & v2 ) ;

	bool contains ( const Volume2D & other ) const ;

	virtual int getArea () const ;

	virtual ~ Volume2D () {}
	
} ;

#endif
