#ifndef __SEMAPHORE_H

#define __SEMAPHORE_H

#include "kernel.h"

unsigned char getSemValue(unsigned char sem);
void setSemValue(unsigned char sem, unsigned char val);
unsigned char higherWaitingTask(unsigned char sem);
void addWaitingTask(unsigned char sem, unsigned char task);
void remWaitingTask(unsigned char sem, unsigned char task);
void waitSem(unsigned char task, unsigned char sem);
void signalSem(unsigned char sem);

typedef struct
{
  prtyStruc waitingTasks;
  unsigned char value;
} semStruc;

#endif
