#ifndef __KERNEL_H

#define __KERNEL_H

/* macros gnrales */

#ifndef MAX_SEM
#define MAX_SEM 0   /* par dfaut, on n'utilise pas les smaphores */
#endif

#ifndef MAX_TASK
#define MAX_TASK 8  /* par dfaut : 8 tches maximum. Ceci est
		       adapt au 16F84, qui a peu de ressources */
#endif

#if (MAX_TASK != 64) && (MAX_TASK != 8)
#define MAX_TASK 64
#endif

#if MAX_SEM > 0
#define USE_SEMAPHORE
#endif

/* fin macros gnrales */
#ifndef di
#define di() ;
#endif
#ifndef ei
#define ei() ;
#endif

#include "dispatch.h"
#include "common.h"

#ifdef HI_TECH_C
#include <pic.h>
#endif

#ifdef USE_SEMAPHORE
#include "sema.h"
#endif

/* macros permettant de raliser les appels systme depuis les
   tches */

#define TASK_START 1
#define TASK_EXIT 2
#define RESCHEDULE 3

#ifdef USE_SEMAPHORE
#define GET_SEM_VALUE 10
#define SET_SEM_VALUE 11
#define WAIT_SEM 12
#define SIGNAL_SEM 13
#endif

#define START_TASK(p, t, n) \
p.pos = n; \
p.task = t; \
p.sysCallCode = TASK_START; \
return &p;

#define EXIT_TASK(p, t, n) \
p.pos = n; \
p.task = t; \
p.sysCallCode = TASK_EXIT; \
return &p;

#define SCHEDULE(p, n) \
p.pos = n; \
p.sysCallCode = RESCHEDULE; \
return &p;

#ifdef USE_SEMAPHORE
#define WAIT(p, s, n) \
p.pos = n; \
p.sem = s; \
p.sysCallCode = WAIT_SEM; \
return &p;

#define SIGNAL(p, s, n) \
p.pos = n; \
p.sem = s; \
p.sysCallCode = SIGNAL_SEM; \
return &p;

#define GET_SEM(p, s, n) \
p.pos = n; \
p.sem = s; \
p.sysCallCode = GET_SEM_VALUE; \
return &p;

#define SET_SEM(p, s, v, n) \
p.pos = n; \
p.sem = s; \
p.val = v; \
p.sysCallCode = SET_SEM_VALUE; \
return &p;
#endif           /* #ifdef USE_SEMAPHORE */

/* fin des macros permettant de raliser les appels systme
   depuis les tches */

/* dfinitions des structures utilises par le kernel */

typedef struct
{
  unsigned char pos;
} taskStruc;

/* fin des dfinitions des structures utilises par le kernel */

/* prototypes des fonctions du kernel qui peuvent tre appeles
   depuis d'autres modules */

void startTask(unsigned char task);
void schedule();
void setTaskBit(prtyStruc *prtyTblPtr, unsigned char task);
unsigned char getTaskBit(prtyStruc *prtyTblPtr, unsigned char task);
void clearTaskBit(prtyStruc *prtyTblPtr, unsigned char task);
void stopTask(unsigned char task);
void restartTask(unsigned char task);
void killTask(unsigned char task);
unsigned char higherTask(prtyStruc tasksPrty);

/* fin des prototypes des fonctions du kernel */

#endif              /* #ifndef __KERNEL_H */
 
