/***  Assembleur MAYBE, B. Boigelot, 12/94                        ***/
/*       25/10/1999 : (JMF) Messages d'erreur plus explicites.      */
/*       26/10/1999 : (JMF) Le nom du fichier de sortie est         */
/*                    maintenant '<InputFileName>.hex'.             */
/*       25/11/1999 : (JMF) Assignement a CURADR (modification de   */
/*                    pc).                                          */
/***                                                              ***/

#include <stdio.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include "ev.h"


/**  defines  **/

#define OUT_EXT ".hex"

/**  Types  **/

typedef struct {
  unsigned char type;
  union {
    unsigned long constant;
    unsigned char symbol;
    char *string;
    } value;
  unsigned long lnb;
  char *filename;
  } token;

typedef struct _list_el {
  void            *value;
  struct _list_el *next;
  } list_el;

typedef struct {
  list_el *first, *last;
  } list;

typedef struct {
  list *pars, *body;
  } macro;

typedef struct _hash {
  char         *name;
  void         *value;
  struct _hash *next;
  } hash;

typedef hash **table;

/**  Prototype indispensable  **/

void *eval_expr(list *);
list *preprocess(list *);

/**  Variables globales  **/

static const char CURADR[] = "Current";
static const unsigned long FILLNUMBER = 0L;
table         m_table, s_table;
unsigned long pc = 0L, pc_old = 0L;
unsigned long lnb = 1L;
char         *cur_filename;

/**  Creation d'un nouvel objet  **/

#define new_object(type) (type *) emalloc(sizeof(type))

/**  Affichage du numero de ligne sur sortie d'erreur standard  **/

void printlnb(void)
{
  fprintf(stderr, "Last token reference in file %s, line %i.\n",
	  cur_filename, lnb);
}

/**  Report d'une erreur et arret de l'assemblage  **/

void error(msg)
  char *msg;
{
  fprintf(stderr, "%s\n", msg);
  exit(0);
}

/**  Allocation de memoire avec detection d'erreur  **/

char *emalloc(size)
  unsigned size;
{
  char *out;

  if (!(out = malloc(size)))
    error("Out of memory.");

  return out;
}

/**  Fonctions et macros de manipulation des listes  **/

list *empty_list() {
  list *out;

  out = new_object(list);
  out -> first = out -> last = NULL;
  return out;
}

void append(l, x)
  list *l;
  void *x;
{
  list_el *n;

  n = new_object(list_el);
  n -> value = x;
  n -> next  = NULL;
  l -> last = l -> last ? (l -> last -> next = n) : (l -> first = n);
}

void concat(l1, l2)
  list *l1, *l2;
{
  list_el *p;

  for (p = l2 -> first; p; p = p -> next)
    append(l1, p -> value);
}

list *map(l, f)
  list *l;
  void *(*f)();
{
  list_el *p;

  for (p = l -> first; p; p = p -> next)
    p -> value = (void *) f(p -> value);

  return l;
}

list *cdr(l)
  list *l;
{
  list *out;

  out = new_object(list);
  out -> first = l -> first -> next;
  out -> last  = l -> last;

  return out;
}

#define first_pair(l, a, b) (*(b) = (*(a) = l -> first) ? \
                             l -> first -> next : NULL)
#define next_pair(a, b)     (*(b) = (*(a) = *(b)) ? ((*(b)) -> next) : NULL)

/**  Fonctions de manipulation des tables de hachage  **/

#define H_SIZE 1024 

unsigned long hash_id(id)
  char *id;
{
  unsigned i, out;

  for (out = i = 0; *id; id++, i++)
    out += (*id + i) * (*id + i) ^ (i * i * i);

  return out % H_SIZE;
}

table new_table() {
  hash   **out;
  unsigned i;

  out = (hash **) emalloc(H_SIZE * sizeof(hash *));

  for (i = 0; i < H_SIZE; i++)
    out[i] = NULL;

  return (table) out;
}

void *entry_in_table(h, id)
  table h;
  char *id;
{
  hash *p;

  for (p = h[hash_id(id)]; p; p = p -> next)
    if (!strcmp(id, p -> name))
      return p -> value;

  return NULL;
}

void *look_in_table(h, id)
  table h;
  char *id;
{
  void *out;

  if (!(out = entry_in_table(h, id))) {
    printlnb();
    fprintf(stderr, "Id not found in id table : %s.\n", id);
    error("Reference to an undefined identifier.");
  }

  return out;
}

void insert_in_table(h, id, new)
  table h;
  char *id;
  void *new;
{
  hash     *p;
  unsigned  x;

  for (p = h[x = hash_id(id)]; p; p = p -> next)
    if (!strcmp(id, p -> name)) {
      p -> value = new;
      return;
      }
  p = new_object(hash);
  p -> name  = id;
  p -> value = new;
  p -> next  = h[x];   
  h[x] = p;
}

void remove_table_entry(h, id)
  table h;
  char *id;
{
  hash *p, *q;
  unsigned x;

  for (p = h[x = hash_id(id)], q = NULL; p; q = p, p = p -> next)
    if (!strcmp(id, p -> name))
      if (q)
        q -> next = p -> next;
      else
        h[x] = p -> next;     
}

/**  Definition des elements lexicaux  **/

#define CONST     1
#define SYMBOL    2
#define IDENT     3
#define END_LINE  4
#define END_EXPR  5
#define MACRO     6
#define INCLUDE   7

/**  Fonctions de manipulation d'elements lexicaux  **/

token *long_to_token(x)
  unsigned long x;
{
  token *t;

  t = new_object(token);
  t -> type = CONST;
  t -> value.constant = x;
  t -> lnb = lnb;
  t -> filename = cur_filename;

  return t;  
}

token *ident_to_token(s)
  char *s;
{
  token *t;

  t = new_object(token);
  t -> type = IDENT;
  t -> value.string = s;
  t -> lnb = lnb;
  t -> filename = cur_filename;

  return t;    
}

token *token_by_type(x)
  unsigned x;
{
  token *t;

  t = new_object(token);
  t -> type = x;
  t -> lnb = lnb;
  t -> filename = cur_filename;

  return t;    
}

token *symbol_to_token(c)
  int c;
{
  token *t;

  t = new_object(token);
  t -> type = SYMBOL;
  t -> value.symbol = (unsigned char) c;
  t -> lnb = lnb;
  t -> filename = cur_filename;

  return t;    
}

/**  Macros d'identification d'un ou de deux caracteres  **/

#define isletter(c)     (isalpha(c)  || (c) == '_')
#define isrsymbol(c)    ((c) == ')'  || isletter(c) || isdigit(c) || (c) == '.')
#define islsymbol(c)    ((c) == '('  || (c) == ','  || (c) == '+' || (c) == '-'  \
       || (c) == '*'  || (c) == '/'  || (c) == '%'  || (c) == '=' || (c) == ':')
#define iskeyword(c, d) ((c) == '.' && isletter(d))
#define isuminus(c, d)  ((c) == '-' && ((d) == '-'  || (d) == '(' || (d) == '.'  \
       || isletter(d) || isdigit(d)))

/**  Valeur d'un chiffre hexadecimal  **/

#define xvalue(c)       (isdigit(c) ? ((c) - '0') : (toupper(c) - 'A' + 10))

/**  Lecture d'un caractere  **/

#define read_char(f, a, b) (*(a) = *(b), (*a=='\n') ? lnb++:0, *(b) = getc(f))

/**  Fonctions de lecture d'un element lexical  **/

unsigned long read_number(f, a, b)
  FILE *f;
  int  *a, *b;
{
  unsigned long v = 0L;
  unsigned int  r = 10, d;

  if (*a == '0')
    switch(*b) {
      case 'x' : read_char(f, a, b);  r = 16;  break;
      case 'b' : read_char(f, a, b);  r =  2;  break;
      }
  else v = xvalue(*a);

  for (; isxdigit(*b) && (d = xvalue(*b)) < r; read_char(f, a, b))
    v = v * r + d;

  return v;
}

#define MAX_ID_LENGTH   256

char *read_ident(f, a, b)
  FILE *f;
  int *a, *b;
{
  static   char tmp[MAX_ID_LENGTH + 1];
  unsigned int  n = 1;

  for (tmp[0] = *a; isletter(*b) || isdigit(*b); read_char(f, a, b))
    if (n < MAX_ID_LENGTH)
      tmp[n++] = *b;

  tmp[n] = 0;

  return strcpy(emalloc(++n), tmp);
}

int read_keyword(f, a, b)
  FILE *f;
  int *a, *b;
{
  char *s;

  read_char(f, a, b);
  s = read_ident(f, a, b);

  if (!strcmp(s, "macro"))   return MACRO;
  if (!strcmp(s, "include")) return INCLUDE;
  
  printlnb();
  error("Invalid keyword.");
    
}

/**  Analyse lexicale  **/

list *lexical(file_name)
  char *file_name;
{
  FILE *f;
  int   a, b, brk, key;
  list *out;


  if (!(f = fopen(file_name, "r"))) {    
    fprintf(stderr, "Error occured while opening %s.\n", file_name);
    error("Cannot open file.");
  }

  for (a = b = ' ', brk = key = 0, out = empty_list(); a != EOF;
       read_char(f, &a, &b)) {
    if (isdigit(a)) {
      append(out, long_to_token(read_number(f, &a, &b)));
      brk = 1;  continue;
      }
    if (isletter(a)) {
      append(out, ident_to_token(read_ident(f, &a, &b))); 
      brk = 1;  continue;
      }     
    if (iskeyword(a, b)) {
      append(out, token_by_type(read_keyword(f, &a, &b))); 
      brk = 0;  key = 1;  continue;
      }     
    if (brk == 2 && isuminus(a, b)) {
      append(out, token_by_type(END_EXPR));
      append(out, symbol_to_token(a));
      brk = 0;  continue;
      }    
    if ((a == '<' || a == '>') && a == b) {
      read_char(f, &a, &b);
      append(out, symbol_to_token(a));
      brk = 0;  continue;
      }
    if (a == '|') {
      while (b != '\n' && b != EOF)
        read_char(f, &a, &b);
      continue;
      } 
    if (isrsymbol(a)) {
      append(out, symbol_to_token(a));
      brk = 1;  continue;
      }     
    if (islsymbol(a)) {
      append(out, symbol_to_token(a));
      brk = 0;  continue;
      }
    if (key && (a == '\n')) {
      append(out, token_by_type(END_LINE));
      key = brk = 0;  continue; 
      }     
    if (!isspace(a)) {
      printlnb();
      error("Syntax error.");
    }

    if (brk)
      brk = 2;
    }

  fclose(f);
  return out;
}

/**  Macros d'identification d'une ou de deux unites lexicales  **/
#define issymb(t, c)       ((t) -> type == SYMBOL && (t) -> value.symbol == (c))
#define isend(t)           (issymb(t, ')') || issymb(t, '.')                    \
     || (t) -> type == CONST || (t) -> type == IDENT)
#define iscont(t)          (issymb(t, '-') || issymb(t, '+') || issymb(t, '*')  \
     || issymb(t, '/')  || issymb(t, '%')  || issymb(t, '<') || issymb(t, '>')  \
     || issymb(t, ')')  || (t) -> type == END_EXPR)
#define isinclude(t1, t2)  ((t1) -> type == INCLUDE && (t2) -> type == IDENT)
#define ismacrodef(t1, t2) ((t1) -> type == MACRO   && (t2) -> type == IDENT)
#define ismacroref(t1, t2) ((t1) -> type == IDENT   && issymb((t2), '(')        \
    && entry_in_table(m_table, (t1) -> value.string))
#define islabeldef(t1, t2) ((t1) -> type == IDENT   && issymb((t2), ':'))
#define isvaldef(t1, t2)   ((t1) -> type == IDENT   && issymb((t2), '=')) 

/**  Acces a l'unite lexicale associee a un element de liste  **/

#define token_el(p) (lnb = ((token *) ((p) -> value))->lnb,\
		     cur_filename = ((token *) ((p) -> value))->filename,\
		     (token *) ((p) -> value))

/**  Lecture de listes et d'expressions  **/

list *read_par_list(a, b)
  list_el **a, **b;
{
  list *out;

  if (!*a || !issymb(token_el(*a), '(')) {
    if (*a) {
      lnb = token_el(*a)->lnb;
      cur_filename = token_el(*a)->filename;
    }
    printlnb();
    error("Syntax error in argument list.\n");
  }

  next_pair(a, b);

  for (out = empty_list(); (*a) && (*b) && token_el(*a) -> type == IDENT
       && (issymb(token_el(*b), ',') || issymb(token_el(*b), ')')); ) {
    append(out, (*a) -> value);
    next_pair(a, b);
    next_pair(a, b);
    }

  if (!out -> first)
    next_pair(a, b);

  return out;
}

list *parenth(a, b)
  list_el **a, **b;
{
  list *out;

  lnb = token_el(*a)->lnb;
  append(out = empty_list(), token_el(*a));
  
  for (next_pair(a, b);; next_pair(a, b)) {
    if (!*a) {
      printlnb();
      error("Missing ')'.");
    }
    if (issymb(token_el(*a), '('))
      concat(out, parenth(a, b));
    else {
      append(out, token_el(*a));
      if (issymb(token_el(*a), ')'))
	return out;
      }
    }
}

list *read_arg(a, b)
  list_el **a, **b;
{
  list *out;

  for (out = empty_list(); (*a) && !issymb(token_el(*a), ',') &&
       !issymb(token_el(*a), ')'); next_pair(a, b)) {
    if (issymb(token_el(*a), '('))
      concat(out, parenth(a, b));
    else
      append(out, token_el(*a));
    }
  return out;
}

list *read_body(a, b)
  list_el **a, **b;
{
  list *out;

  for (out = empty_list(); (*a) && token_el(*a) -> type != END_LINE;
       next_pair(a, b))
    append(out, token_el(*a));

  return out;
}

list *read_expr(a, b)
   list_el **a, **b;
{
  list *out;

  for (out = empty_list(); *a; next_pair(a, b)) {
    append(out, token_el(*a));   
    if ((token_el(*a) -> type == END_EXPR) || !*b ||
        (isend(token_el(*a)) && !iscont(token_el(*b))))
      break;
    }

  return out;
} 

/**  Pretraitement (expansion des macros et inclusion de fichiers)  **/

list *expand(pars, body, a, b)
  list     *pars, *body;
  list_el **a, **b;
{
  list *out;
  void *save;
  char *id;

  if (issymb(token_el(*a), ',') || issymb(token_el(*a), '('))
    if (pars -> first) {
      save = entry_in_table(s_table, id = token_el(pars -> first) -> value.string);
      next_pair(a, b);
      insert_in_table(s_table, id, preprocess(read_arg(a, b)));
      out = expand(cdr(pars), body, a, b);
      if (save)    
        insert_in_table(s_table, id, save);
      else
        remove_table_entry(s_table, id);
      return out;
      }
    else next_pair(a, b);
   
  if (issymb(token_el(*a), ')') && !pars -> first)
    return preprocess(body);
  
  printlnb();
  error("Syntax error while expanding a macro.");
}

list *preprocess(in)
  list *in;
{
  list_el *a, *b;
  char    *id;
  list    *out;
  macro   *m;
  void    *v;

  for (first_pair(in, &a, &b), out = empty_list(); a; next_pair(&a, &b)) {
    lnb = token_el(a)->lnb;
    cur_filename = token_el(a)->filename;

    if (b && isinclude(token_el(a), token_el(b))) {
      unsigned long tmp_lnb = lnb;
      char *tmp_filename = cur_filename;

      id = token_el(b) -> value.string;
      next_pair(&a, &b);
      next_pair(&a, &b);
      cur_filename = id;
      lnb = 1L;
      concat(out, preprocess(lexical(id)));

      lnb = tmp_lnb;
      cur_filename = tmp_filename;
      continue;
      }
    if (b && ismacrodef(token_el(a), token_el(b))) {
      id = token_el(b) -> value.string;
      next_pair(&a, &b);
      next_pair(&a, &b);
      m = new_object(macro);
      m -> pars = read_par_list(&a, &b);
      m -> body = read_body(&a, &b);
      insert_in_table(m_table, id, (void *) m);
      continue;
      }
    if (b && ismacroref(token_el(a), token_el(b))) {
      id = token_el(a) -> value.string;
      next_pair(&a, &b);
      m = (macro *) look_in_table(m_table, id);
      concat(out, expand(m -> pars, m -> body, &a, &b));
      continue;
      }
    if (token_el(a) -> type == IDENT &&
	(v = entry_in_table(s_table, token_el(a) -> value.string)))
      concat(out, (list *) v);
    else
      append(out, token_el(a));  
    }
  return out;
}

/**  Premiere passe  **/

list *long_to_expr(x)
  unsigned long x;
{
  list *out;

  append(out = empty_list(), long_to_token(x));

  return out;
}

unsigned long *new_long(x)
  unsigned long x;
{
  unsigned long *out;

   out = new_object(unsigned long);
  *out = x;

  return out;
}

void *eval_dot(x)
  void *x;
{
  return issymb((token *) x, '.') ? long_to_token(pc) : (token *) x;
}

list *generate(in)
  list *in;
{
  list_el *a, *b, *id;
  list    *out;

  for (first_pair(in, &a, &b), out = empty_list(); a; next_pair(&a, &b)) {
    if (b && islabeldef(token_el(a), token_el(b))) {
      id = a;
      next_pair(&a, &b);
      insert_in_table(s_table, token_el(id) -> value.string, long_to_expr(pc));
      continue;
      }
    if (b && isvaldef(token_el(a), token_el(b))) {
      char *id_string;
      id = a; 
      next_pair(&a, &b);
      next_pair(&a, &b);
      insert_in_table(s_table, id_string = token_el(id) -> value.string,
          map(read_expr(&a, &b), eval_dot));

      if (!strcmp(CURADR, id_string))
	{
	  pc_old = pc;
	  if ((pc = *(unsigned long *)
		 eval_expr((void *) look_in_table(s_table, CURADR))) < pc_old)
	    {
	      printlnb();
	      fprintf(stderr, "Trying to assign %u to %s, but current address "
		      "is greater (%u).\n", pc, CURADR, pc_old);
	      error("Aborting.\n");
	    }
	  for (; pc_old != pc; pc_old++)
	    append(out, long_to_expr(FILLNUMBER));
	}
      continue;
      }
    append(out, map(read_expr(&a, &b), eval_dot));
    pc++;
    }

  return out;
}

/**  Deuxieme passe  **/

void token_to_lex_unit(t, l)
  token    *t;
  lex_unit *l;
{
  switch(t -> type) {
    case SYMBOL   : switch(t -> value.symbol) {
                      case '(' : l -> symbol = LPAR;   return;
                      case ')' : l -> symbol = RPAR;   return;
                      case '&' : l -> symbol = AND;    return;
                      case '+' : l -> symbol = PLUS;   return;
                      case '-' : l -> symbol = MINUS;  return;
                      case '*' : l -> symbol = MULT;   return;
                      case '/' : l -> symbol = DIV;    return;
                      case '%' : l -> symbol = MOD;    return;
                      case '<' : l -> symbol = LSHIFT; return;
                      case '>' : l -> symbol = RSHIFT; return;
                      default  : printlnb(); error("Invalid token.");
                      }
  
    case CONST    : l -> symbol = CONST;
                    l -> value  = t -> value.constant;
                    break; 
    case END_EXPR : l -> symbol = END;
                    break;
    default       : printlnb(); error("Cannot evaluate.");
    }
}

void *eval_expr(in)
  list *in;
{
  list          *e;
  list_el       *a;
  token         *c;
  lex_unit       t;
  unsigned long *p, v;

  for (e = empty_list(), a = in -> first; a; a = a -> next) {
    c = token_el(a);
    if (c -> type == IDENT) {
      p = eval_expr((void *) look_in_table(s_table, c -> value.string));
      append(e, long_to_token(*p));
      insert_in_table(s_table, c -> value.string, long_to_expr(*p));
      }
    else
      append(e, c);
    }
   append(e, token_by_type(END_EXPR));

  for (ev_init(), a = e -> first; a; a = a -> next) {  
    token_to_lex_unit(token_el(a), &t);
    switch(ev_token(&t, &v)) {
      case ERR : printlnb(); error("Expression parse error.");
      case EXC : printlnb(); error("Arithmetic exception.");
      case VAL : return (void *) new_long(v);
      }
    }
}

/**  Sortie des resultats  **/

void output(l, fn)
  list *l;
  char *fn;
{
  FILE    *f;
  list_el *p;
  unsigned n;
  char    *outfilename = emalloc(strlen(fn)+sizeof(OUT_EXT)+1);
 
  strcpy(outfilename, fn);
  strcpy(outfilename+strlen(fn), OUT_EXT);

  if (!(f = fopen(outfilename, "w")))
    error("Cannot create output file.");

  for (p = l -> first, n = 0; p; p = p -> next) {
    fprintf(f, " %02X", (*((unsigned long *) (p -> value))) & 0xff);
    if (!(++n % 16) || !(p -> next))
      fprintf(f, "\n");
    }
  fclose(f);
}

/**  Point d'entree  **/

main(argc, argv)
  int   argc;
  char *argv[];
{
  if (argc < 2)
    error("Missing argument.");

  m_table = new_table();
  s_table = new_table();

  cur_filename = argv[1];

  output(map(generate(preprocess(lexical(argv[1]))), eval_expr), argv[1]);

  exit(0);
}
