/****************************************************************************/
/**                                                                        **/
/**  ev.h  : Evaluateur simple.                                            **/
/**  ----                                                                  **/
/**                                                                        **/
/**  B. Boigelot, 10/94.                                                    **/
/**                                                                        **/
/****************************************************************************/

/****************************************************************************

  Mode d'emploi
  =============

  a) #include "ev.h"          pour definir les symboles, les codes de retour,
                              et le type lex_unit.
  
  b) ev_init();               pour initialiser l'evaluateur (c'est-a-dire le
                              preparer a evaluer une nouvelle expression).

  c) lex_unit      token;
     unsigned long value;
     int           status;

     token.symbol = ... ;
     token.value  = ... ;

     status = ev_token(&token, &value);

                              pour passer un nouvel element lexical 'token'
                              a l'evaluateur. Le champ 'token.symbol' doit
                              contenir le code de l'element lexical concerne
                              (CONST, LPAR, ...) ou END pour signifier la fin
                              de la sequence d'entree. Si l'element lexical
                              est une constante (CONST), le champ
                              'token.value' doit contenir la valeur de cette
                              constante. 'ev_token' renvoie ERR en cas
                              d'erreur de syntaxe ou de depassement, EXC en
                              de division par zero, VAL si le resultat de
                              l'evaluation est disponible dans 'value', et
                              OK dans toutes les autres situations.

  d) cc -o mon-programme mon-programme.c ev.o

                              pour lier au programme le code objet de
                              l'evaluateur.

*****************************************************************************/

/******
  Symboles
******/

#define  END       0
#define  CONST     1
#define  LPAR      2
#define  RPAR      3
#define  AND       4
#define  PLUS      5
#define  MINUS     6
#define  MULT      7
#define  DIV       8
#define  MOD       9
#define  LSHIFT   10
#define  RSHIFT   11

/******
  Codes de retour pour ev_token()
******/

#define  OK        0
#define  ERR       1
#define  VAL       2
#define  EXC       3

/******
  Definition du type "unite lexicale"
******/

typedef struct {
  char          symbol;
  unsigned long value;
  } lex_unit;

/******
  Prototypes
******/

void ev_init();
int  ev_token();
