| Beta programme d'exemple.
| Demonstration de l'adressage virtuel et de la
| priorite 'privilege'


.include betainstr
.include convbetainstr

| Ce programme necessite la presence d'un fichier nomme 'betafibo' dans
| le meme repertoire que lui-meme.

PID = 1				| PID du programme lance (1, 2,..., 7)
	
	bsetclkc(0x0FFF)	| Pour empecher les interruptions d'horloge
				| (celle-ci ne se declenchera qu'apres 0x0FFF
				| instructions, ce qui est tres long)
	bcmove(PID, r(0))
	bshlc(r(0), 16, r(0))	| Le PID se trouve dans le 3e byte de R0
	bjmp(r(0), R31)		| Apres ce saut, la priorite 'privilege' est
				| perdue puisque l'adresse contenue dans R0
				| n'a pas son bit de poids le plus fort
				| mis a '1'

	
Current = 0x2000 * PID		| Car le programme de PID 'x' doit se
				| trouver en DRAM entre les adresses
				| '0x2000 * x' et '0x2000 * (x+1) - 1'

.include betafibo		| Le programme proprement dit apparait ici.
				| Il semblerait plus naturel d'ecrire
				| .include betafib.asm
				| mais malheureusement l'assembleur
				| refuse d'include des fichiers dont le
				| nom comporte un point ('.').
				| Je reglerai ce probleme des que j'en
				| aurai le temps