| Complete MAYBE G-Machine Microcode

| 11/01/1999 : (JMF) Creation
|              Differences with MIT's implementation :
|               - support for virtual adressing according
|                 to the content of PID (see microsub).
|                 PID is the third byte of PC.

| 32-bit G-machine architecture: microcode support.

| Some SRAM registers reserved for particular purposes.
| machine-level register definitions (each is 4 bytes long).

BR0     = 32            | Register 0
BR1     = BR0+4
BR2     = BR1+4
BR3     = BR2+4
BR4     = BR3+4
BR5     = BR4+4
BR6     = BR5+4
BR7     = BR6+4
BR8     = BR7+4
BR9     = BR8+4	
BR10    = BR9+4
BR11    = BR10+4
BR12    = BR11+4
BR13    = BR12+4
BR14    = BR13+4
BR15    = BR14+4
BR16    = BR15+4
BR17    = BR16+4
BR18    = BR17+4
BR19    = BR18+4	
BR20    = BR19+4
BR21    = BR20+4
BR22    = BR21+4
BR23    = BR22+4
BR24    = BR23+4
BR25    = BR24+4
BR26    = BR25+4
BR27    = BR26+4
BR28    = BR27+4
BR29    = BR28+4
BR30    = BR29+4
BR31    = BR30+4

BP      = BR27		| Base of frame Pointer.
LP      = BR28		| Linkage Pointer.
SP      = BR29		| Stack pointer.
XP      = BR30		| eXeption Pointer
	
PC      = BR31+4	| Program Counter.
PID	= PC+2		| Process ID is third byte of PC.

Prty    = PC+4		| Interrupt enable/disable byte. 
Spare3	= Prty+1
	
Op1     = Prty+4	| Temporary results and operands (each 4 bytes wide).
Op2     = Op1+4
Op3     = Op2+4
Op4     = Op3+4
Op5     = Op4+4
Op6     = Op5+4
LastOp  = Op6

BRA     = LastOp+4
BRC     = BRA+1
BRB     = BRC+1
BLIT    = BRB
BLITLO  = BLIT
BLITHI  = BLITLO+1
PRIV0	= BRA		| Privileged instruction
PRIV1	= PRIV0+1
PRIV2	= PRIV1+1
PRIV3	= PRIV2+1
	
.include macros
.include console
.include microsub

| Fetch a byte from G-machine's instruction stream into SRAM x.
| Increments PC.

.macro fetch(x) vl(PC, PC+1, x) cadd2(1, PC, PC)
	
| beta machine: microcode implementation for MAYBE.

| Each instruction is encoded as an opcode byte followed by zero or more
| operands. For opcodes that may have differing lengths of operands, we
| have followed the convention that the low 2 bits of each opcode specify
| operand length, as follows:
| 00      1 byte
| 01      2 bytes (low, high)
| 10      4 bytes
| 11      (unused, at present)


| Microsubroutine to initialize virtual Beta machine state:

MInit:	cmove4(0x80000000, PC)	| Start at beginning, set privilege bit,
				| PID = 0 (kernel mode).
	cmove(MAXPRI, Prty)	| Initially disable interrupts.
	jmp(Mintinit)		| Goto interrupt initialization.

	
| Interrupt handler. If an interrupt condition is recognized by the
| Mintest routine, then Mint is called with the address of the interrupt
| vector in Minth. Mint saves the old PC in XP, then get new PC and
| enter privileged mode.

Mint:
	refr() refr() refr()	| A few refreshes.
	refr() refr() refr()
	
	cmove(MAXPRI, Prty)	| Disable interrupts.
        move4(PC, XP)		| Save interrupt-time PC into XP
	cmove4(0x0, PC)		| Zeroize PID (else get4 wont be able to
				| access Minth)
        move2(Minth, R0)	| Prepare to read from interrupt vector.
        cmove(PC, R2)		| First get4 goes into the PC.
        call(get4)		| PC <- <vector_address>.
        cor(0x80, PC+3, PC+3)	| Sets high bit of PC if not done by vector

	rtn()			| Continue with instruction fetch.


| Main G instruction fetch/execute microsubroutine.
| Dispatches to an G inctruction handler, which returns to caller
| of NextInst via a rtn() microinstruction.

NextInst:
	fetch(R0)		| Get opcode + beg. of Rc
	cand(0b11000000, R0, BRC)	| Privileged instruction ?
	ccmp(0x00, BRC)
	je(NextInstPriv)	| Jump if privileged instruction
	cand(0b11, R0, BRC)	| Get bits 0 and 1 of Rc
	rotl3(BRC, BRC)
	cand(0b11111100, R0, R0)| Get opcode in R0
	rotr2(R0, R0)
	
	fetch(BRA)		| Get next byte
	cand(0b11100000,BRA,BRB)| Rb used as temp. storage for Rc[0..2]
	rotr5(BRB, BRB)
	or(BRB, BRC, BRC)	| Rc is completed
	cand(0b11111, BRA, BRA)	| Ra is completed
	rotl2(BRA, BRA)		| Adjust Ra and Rc to get addresses of regs.
	rotl2(BRC, BRC)		| ...first multiply by 4 (32 bits registers)
	cadd(BR0, BRA, BRA)	| ...second add first reg address
	cadd(BR0, BRC, BRC)
	
	fetch(BLIT)		| Fetch Rb or Literal
	cand(0b110000, R0, R1)
	ccmp(0b100000, R1)	| Does the opcode begin with 0b10 ?
	jne(NextInstlit)	| No : Last bytes of opcode = literal
NextInstnolit:
	cadd2(1, PC, PC)	| Yes : Last byte is not useful
	cand(0b11111000, BRB, BRB)
	rotr1(BRB, BRB)		| Adjust Rb to get address of <Rb>'s
	cadd(BR0, BRB, BRB)	| register, so multiply by 4 and add
	jmp(NextInstdispatch)	| the address of BR0
NextInstlit:
	fetch(BLITHI)
	jmp(NextInstdispatch)
NextInstPriv:
	ccmp(MAXPRI, Prty)	| Using a privileged instruction, but not
	jne(hii)		| in privilege mode => jump to hii
	move(R0, PRIV0)
	fetch(PRIV1)
	fetch(PRIV2)
	fetch(PRIV3)
	cand(0b11111100, PRIV0, R0)	| Put opcode in R0
	rotr2(R0, R0)
NextInstdispatch:
	refr() refr() refr()	| 54 refreshes (NextInst is as long
	refr() refr() refr()	| as an instruction).
	refr() refr() refr()
	
.include breakpoint		| Eventually put a bpt (for simulator).
	dispatch(R0, ITab)	| Dispatch through Instruction Table,
				| Note: dispatch(...) uses 2<R0> for offset
                                | This is the 2^6-entry instruction dispatch
	                        | table :

| Note: hhalt and hii are prefied by "h" (as opposed to "hb")

| since these are generic instructions that will be used by the S, beta
| and the G machines.

| The tags (loc0??) are used merely to facilitate lookup by humans
| of table locations. (REMEMBER: location 2X corresponds to opcode X.)

ITab:
loc0x00:        WORD(hhalt)	WORD(hbsetclk)	WORD(hii)	WORD(hii)
loc0x08:        WORD(hii)	WORD(hbsetclkc)	WORD(hii)	WORD(hii)
loc0x10:        WORD(hii)	WORD(hii)	WORD(hii)	WORD(hii)
loc0x18:        WORD(hii)	WORD(hii)	WORD(hii)	WORD(hii)
loc0x20:        WORD(hii)	WORD(hii)	WORD(hii)	WORD(hii)
loc0x28:        WORD(hii)	WORD(hii)	WORD(hii)	WORD(hii)
loc0x30:        WORD(hbld)	WORD(hbst)	WORD(hbsvcall)	WORD(hbjmp)   
loc0x38:        WORD(hii)	WORD(hbbeq)	WORD(hbbne)	WORD(hbldr)
loc0x40:        WORD(hbadd)	WORD(hbsub)	WORD(hbmul)	WORD(hbdiv)
loc0x48:        WORD(hbcmpeq)	WORD(hbcmplt)	WORD(hbcmple)	WORD(hii) 
loc0x50:        WORD(hband)	WORD(hbor)	WORD(hbxor)	WORD(hii)   
loc0x58:        WORD(hbshl)	WORD(hbshr)	WORD(hbsra)	WORD(hii)   
loc0x60:        WORD(hbaddc)	WORD(hbsubc)	WORD(hbmulc)	WORD(hbdivc)
loc0x68:        WORD(hbcmpeqc)	WORD(hbcmpltc)	WORD(hbcmplec)	WORD(hii)
loc0x70:        WORD(hbandc)	WORD(hborc)	WORD(hbxorc)	WORD(hii)
loc0x78:        WORD(hbshlc)	WORD(hbshrc)	WORD(hbsrac)	WORD(hbpt)


| Microcoded instruction handlers for MAYBE beta-machine instruction set.


| bld(Ra, literal, Rc) : Rc <- Memory[<Ra> + SEXT(literal)]
	
hbld:	move(BRA, R0)		| Op1 <- <<BRA>>
	cmove(Op1, R1)
	call(brload)
	add2(BLIT, Op1, R0)
bldOp1Rc:
	move(BRC, R2)		| <BRC> <- <Op1>
	call(get4)		| Load from DRAM
	rtn()

	
| bldr(label, Rc) : Rc <- Memory[<PC> + 4 * SEXT(label)]
|	literal = ((OFFSET(label) - OFFSET(current instruction)) >> 2 ) - 1

hbldr:	add2(BLIT, BLIT, BLIT)	| Multiply literal by 4
	add2(BLIT, BLIT, BLIT)
	add2(PC, BLIT, R0)
	jmp(bldOp1Rc)

	
| bst(Rc, literal, Ra) : Memory[<Ra> + SEXT(literal)] <- <Rc>

hbst:	move(BRA, R0)		| Op1 <- <<BRA>>
        cmove(Op1, R1)
        call(brload)
	move(BRC, R0)		| Op2 <- <<BRC>>
        cmove(Op2, R1)
        call(brload)
	add2(BLIT, Op1, R0)	| Computes DRAM address
	cmove(Op2, R2)		| Store in DRAM
	call(put4)
	rtn()
	

| bjmp(Ra, Rc) : Rc <- <PC>, PC <- (<Ra> AND 0xFFFFFFFC),
|       reset high bit of PC if needed

hbjmp:	cmove(PC, R0)           | Rc <- <PC>
        move(BRC, R1)
        call(imovei4)
	move(PID, Op1)		| Save PID.
	move(BRA, R0)		| PC <- <<BRA>>
	cmove(PC, R1)
	call(brload)
	cand(0xFC, PC, PC)	| Mask low 2 bits of <PC>
	ccmp(0, Prty)		| If Prty == 0, clear privilege bit
	jne(bjmpsv)		| else set it according to privilege bit of PC
	cand(0x7F, PC+3, PC+3)	| Mask privilege bit of PC
	move(Op1, PID)		| Restore PID.
	jmp(bjmpend)
bjmpsv:	cand(0x80, PC+3, R0)	| Set/Reset Prty according to privilege bit
	ccmp(0x80, R0)		| of PC
	je(bjmpend)
	cmove(0, Prty)		| Disable interrupts
bjmpend:rtn()

	
| bbeq(Ra, label, Rc) : Rc <- PC.  Branch iff <Ra> == 0
|	literal = ((OFFSET(label) - OFFSET(current instruction)) >> 2 ) - 1
		
hbbeq:	cmove(PC, R0)		| Rc <- <PC>
	move(BRC, R1)
	call(imovei4)
	move(BRA, R0)		| Op1 <- <<BRA>>
	cmove(Op1, R1)
	call(brload)
	ccmp(0, Op1)		| Branch ?
	jne(bbdontbranch)
	ccmp(0, Op1+1)
	jne(bbdontbranch)
	ccmp(0, Op1+2)
	jne(bbdontbranch)
	ccmp(0, Op1+3)
	jne(bbdontbranch)
bbbranch:
	add2(BLIT, BLIT, BLIT)	| Multiply literal by 4
	add2(BLIT, BLIT, BLIT)
	add2(PC, BLIT, PC)
bbdontbranch:
	rtn()


| bbne(Ra, label, Rc) : Rc <- PC.  Branch iff <Ra> <> 0
|	literal = ((OFFSET(label) - OFFSET(current instruction)) >> 2 ) - 1
		
hbbne:	cmove(PC, R0)		| <BRC> <- <PC>
	move(BRC, R1)
	call(imovei4)
	move(BRA, R0)		| Op1 <- <<BRA>>
	cmove(Op1, R1)
	call(brload)
	ccmp(0, Op1)		| Branch ?
	jne(bbbranch)
	ccmp(0, Op1+1)
	jne(bbbranch)
	ccmp(0, Op1+2)
	jne(bbbranch)
	ccmp(0, Op1+3)
	jne(bbbranch)
	jmp(bbdontbranch)

	
| bdiv(Ra, Rb, Rc) : Rc <- <Ra>/<Rb>.  Result is truncated.

hbdiv:  move(BRB, R0)		| divisor <- <<BRB>>
	cmove(divisor, R1)
	call(brload)
bdivOp1Ra:
	move(BRA, R0)		| dividend <- <<BRA>>
	cmove(dividend, R1)
	call(brload)
bdivOp1Op2:
	call(divide)		| Performs dividend/divisor -> quotient
	cmove(quotient, R0)	| <BRC> <- <Op4>
	move(BRC, R1)
	call(imovei4)
	rtn()


| bdivc(Ra, literal, Rc) : Rc <- <Ra>/SEXT(literal).  Result is truncated.

hbdivc: call(sextlit)		| divisor <- SEXT(literal)
				| Works because divisor = Op1
	jmp(bdivOp1Ra)


| bmul(Ra, Rb, Rc) : Rc <- <Ra> x <Rb>.  Result is truncated.

hbmul:  move(BRB, R0)		| multiplier <- <<BRB>>
	cmove(multiplier, R1)
	call(brload)
bmulOp1Ra:
	move(BRA, R0)		| multiplicand <- <<BRA>>
	cmove(multiplicand, R1)
	call(brload)
bmulOp1Op2:
	call(mult)		| Performs multiplier x multiplicand ->
				|            product
	cmove(product, R0)
	move(BRC, R1)
	call(imovei4)		| <BRC> <- <Op4>
	rtn()


| bmulc(Ra, literal, Rc) : Rc <- <Ra> x SEXT(literal).  Result is truncated.

hbmulc: call(sextlit)		| multiplier <- SEXT(literal)
				| Works because multiplier = Op1
	jmp(bmulOp1Ra)
	
	
| badd(Ra, Rb, Rc) : Rc <- <Ra> + <Rb>	
	
hbadd:	move(BRB, R0)		| Op1 <- <<BRB>>
	cmove(Op1, R1)
	call(brload)
baddOp1Ra:
	move(BRA, R0)		| Op2 <- <<BRA>>
	cmove(Op2, R1)
	call(brload)
baddOp1Op2:
	add2(Op1, Op2, Op2)	| Op2 <- <Op1> + <Op2>
        addcy(Op2+2, Op1+2, Op2+2)
        addcy(Op2+3, Op1+3, Op2+3)	
	cmove(Op2, R0)		| <BRC> <- <Op2>
	move(BRC, R1)
	call(imovei4)
	rtn()


| baddc(Ra, literal, Rc) : Rc <- <Ra> + SEXT(literal)
	
hbaddc: call(sextlit)		| Op1 <- SEXT(literal)
        jmp(baddOp1Ra)

	
| bsub(Ra, Rb, Rc) : Rc <- <Ra> - <Rb>
	
hbsub:	move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
bsubOp1Ra:
        move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
bsubOp1Op2:
        sub2(Op2, Op1, Op2)	| Op2 <- <Op2> - <Op1>
        subcy(Op2+2, Op1+2, Op2+2)
        subcy(Op2+3, Op1+3, Op2+3)
        cmove(Op2, R0)		| <BRC> <- <Op2>
        move(BRC, R1)
        call(imovei4)
        rtn()

	
| bsubc(Ra, literal, Rc) : Rc <- <Ra> - SEXT(literal)
	
hbsubc: call(sextlit)		| Op1 <- SEXT(literal)
	jmp(bsubOp1Ra)


| bshr(Ra, Rb, Rc) : Rc <- <Ra> >> <Rb>4:0 (logically)

hbshr:	move(BRB, R0)		| Op2 <- <<BRB>>
	cmove(Op2, R1)
	call(brload)
	cand(0b11111, Op2, Op2) | Use bits 4:0
bshrOp2Ra:
	move(BRA, R0)		| Op1 <- <<BRA>>
	cmove(Op1, R1)
	call(brload)
bshrOp2Op1:
	neg(Op2, Op2)		| -Op2 because right shift (see shift)
	cmove(0, Op3)		| Op3 <- 0  (only 1 byte of Op2 & Op3 is used)
	call(shift)		| Performs <Op1> >> <Op2> logically
bsOp1Rc:cmove(Op1, R0)		| <BRC> <- <Op1>
	move(BRC, R1)
	call(imovei4)
	rtn()

	
| bshrc(Ra, literal, Rc) : Rc <- <Ra> >> SEXT(literal)4:0 (logically)

hbshrc:	cand(0b11111, BLIT, Op2)| (only 1 byte of Op2 is used)
	jmp(bshrOp2Ra)


| bshl(Ra, Rb, Rc) : Rc <- <Ra> << <Rb>4:0

hbshl:	move(BRB, R0)		| Op2 <- <<BRB>>
	cmove(Op2, R1)
	call(brload)
	cand(0b11111, Op2, Op2) | Use bits 4:0
bshlOp2Ra:
	move(BRA, R0)		| Op1 <- <<BRA>>
	cmove(Op1, R1)
	call(brload)
bshlOp2Op1:
	call(shift)		| Performs <Op1> << <Op2>
	jmp(bsOp1Rc)

	
| bshlc(Ra, Rb, Rc) : Rc <- <Ra> << SEXT(literal)4:0

hbshlc:	cand(0b11111, BLIT, Op2)| (only 1 byte of Op2 is used)
	jmp(bshlOp2Ra)


| bsra(Ra, Rb, Rc) : Rc <- <Ra> >> <Rb>4:0 (arithmetically)

hbsra:  move(BRB, R0)		| Op2 <- <<BRB>>
        cmove(Op2, R1)
        call(brload)
	cand(0b11111, Op2, Op2) | Use bits 4:0
bsraOp2Ra:
        move(BRA, R0)		| Op1 <- <<BRA>>
        cmove(Op1, R1)
        call(brload)
bsraOp2Op1:
        neg(Op2, Op2)		| -Op2 because right shift
        cand(0x80, Op1+3, Op3)	| Keep sign for arithmetic shift
	ccmp(0, Op3)
        call(shift)		| Performs <Op1> >> <Op2> arithmetically
	jmp(bsOp1Rc)		| <BRC> <- <Op1>


| bsrac(Ra, literal, Rc) : Rc <- <Ra> >> SEXT(literal)4:0 (arithmetically)

hbsrac:	cand(0b11111, BLIT, Op2)| (only 1 byte of Op2 is used)
	jmp(bsraOp2Ra)


| band(Ra, Rb, Rc) : Rc <- <Ra> AND <Rb>

hband:	move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
bandOp1andRa:
	move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
bandOp1andOp2:	
        and(Op1, Op2, Op1)	| Performs <Op1> AND <Op2> on each single byte
        and(Op1+1, Op2+1, Op1+1)
        and(Op1+2, Op2+2, Op1+2)
        and(Op1+3, Op2+3, Op1+3)
bandOp12Rc:
        cmove(Op1, R0)		| <BRC> <- <Op1>
        move(BRC, R1)
        call(imovei4)
        rtn()


| bandc(Ra, literal, Rc) : Rc <- <Ra> AND SEXT(literal)

hbandc:	call(sextlit)		| Op1 <- SEXT(literal)
	jmp(bandOp1andRa)


| bor(Ra, literal, Rc) : Rc <- <Ra> OR <Rb>

hbor:	move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
borOp1orRa:
	move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
borOp1orOp2:	
        or(Op1, Op2, Op1)	| Performs <Op1> OR <Op2> on each single byte
        or(Op1+1, Op2+1, Op1+1)
        or(Op1+2, Op2+2, Op1+2)
        or(Op1+3, Op2+3, Op1+3)
	jmp(bandOp12Rc)


| borc(Ra, literal, Rc) : Rc <- <Ra> OR SEXT(literal)

hborc:  call(sextlit)		| Op1 <- SEXT(literal)
	jmp(borOp1orRa)


| bxor(Ra, literal, Rc) : Rc <- <Ra> XOR <Rb>

hbxor:	move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
bxorOp1xorRa:
	move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
bxorOp1xorOp2:
	xor(Op1, Op2, Op1)	| Performs <Op1> XOR <Op2> on each single byte
	xor(Op1+1, Op2+1, Op1+1)
	xor(Op1+2, Op2+2, Op1+2)
	xor(Op1+3, Op2+3, Op1+3)
	jmp(bandOp12Rc)		| <BRC> <- <Op1>


| xorc(Ra, literal, Rc) : Rc <- <Ra> XOR SEXT(literal)

hbxorc:	call(sextlit)		| Op1 <- SEXT(literal)
	jmp(bxorOp1xorRa)

	
| bcmpeq(Ra, Rb, Rc) : If <Ra> == <Rb> then Rc <- 1 else Rc <- 0

hbcmpeq:move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
bcmpeqOp1Ra:
        move(BRA, R0)
        cmove(Op2, R1)
        call(brload)		| Op2 <- <<BRA>>
bcmpeqOp1Op2:
        cmp(Op1, Op2)		| Compare Op1 and Op2 for each byte
        jne(bcmpfalse)
        cmp(Op1+1, Op2+1)
        jne(bcmpfalse)
        cmp(Op1+2, Op2+2)
        jne(bcmpfalse)
        cmp(Op1+3, Op2+3)
        jne(bcmpfalse)
bcmptrue:
	cmove4(1, Op1)		| Rc <- 1
	jmp(bcmpOp12Rc)
bcmpfalse:
	cmove4(0, Op1)		| Rc <- 0
bcmpOp12Rc:
	cmove(Op1, R0)		| <BRC> <- <Op1>
	move(BRC, R1)
	call(imovei4)
	rtn()


| bcmpeqc(Ra, literal, Rc) : If <Ra> == SEXT(literal) then Rc <- 1 else Rc <- 0

hbcmpeqc:
        call(sextlit)		| Op1 <- SEXT(literal)
	jmp(bcmpeqOp1Ra)


| bcmple(Ra, Rb, Rc) : If <Ra> <= <Rb> then Rc <- 1 else Rc <- 0

hbcmple:move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
hbcmpleOp1Ra:
        move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
hbcmpleOp1Op2:
        sub2(Op1, Op2, Op1)	| Op1 <- <Op1> - <Op2>
        subcy(Op1+2, Op2+2, Op1+2)
        subcy(Op1+3, Op2+3, Op1+3)
        jmi(bcmpfalse)		| If flag says < 0 then guardian is false
        jmp(bcmptrue)		| ...else guardian is true


| bcmplec(Ra, literal, Rc) : If <Ra> <= SEXT(literal) then Rc <- 1 else Rc <- 0

hbcmplec:
        call(sextlit)		| Op1 <- SEXT(literal)
	jmp(hbcmpleOp1Ra)


| bcmplt(Ra, Rb, Rc) : If <Ra> < <Rb> then Rc <- 1 else Rc <- 0

hbcmplt:move(BRB, R0)		| Op1 <- <<BRB>>
        cmove(Op1, R1)
        call(brload)
hbcmpltOp1Ra:
        move(BRA, R0)		| Op2 <- <<BRA>>
        cmove(Op2, R1)
        call(brload)
hbcmpltOp1Op2:
        sub2(Op2, Op1, Op1)	| Op1 <- <Op2> - <Op1>
        subcy(Op2+2, Op1+2, Op1+2)
        subcy(Op2+3, Op1+3, Op1+3)
        jmi(bcmptrue)		| If flag says < 0 then guardian is false
        jmp(bcmpfalse)		| ...else guardian is true


| bcmpltc(Ra, literal, Rc) : If <Ra> < SEXT(literal) then Rc <- 1 else Rc <- 0

hbcmpltc:
	call(sextlit)		| Op1 <- SEXT(literal)
	jmp(hbcmpltOp1Ra)

	
| bsetclk(Ra) :	MClkCount <- <Ra>
	
hbsetclk:
	cand(0x1F, PRIV1, PRIV1)| Mclkcount <- <<BRA>>
	rotl2(PRIV1, PRIV1)	| Multiply by 4
	cadd(BR0, PRIV1, R0)	| Add first reg address
        cmove(Mclkcount, R1)
        call(brload)
	rtn()

	
| bsetclkc(literal) : MClkCount <- literal
	
hbsetclkc:
	call(sextlit)		| Op1 <- SEXT(literal)
	move4(Op1, Mclkcount)
	rtn()
	

| bsvcall() : Supervisor call. Causes an interrupt.

hbsvcall:
	cmove2(SSVCVEC, Minth)
	call(Mint)
	rtn()

	
	
| Subroutines

| sextlit: Extends Literal to 32 bits.  Puts result in Op1.
sextlit:move2(BLIT, Op1)	| Takes literal
	cadd(0, Op1+1, Op1+1)	| Takes sign bit (high bit of the 2nd byte)
	cmove(0, R0)		| R0 <- 0x00
	jpl(sextlitgtz)		| If literal > 0 then fill with 0's
	cmove(0xFF, R0)		| else fill with 1's (r0 <- 0xFF)
sextlitgtz:
	move(R0, Op1+2)
	move(R0, Op1+3)          | the higher word of Op1
	rtn() 


| brload : loads the content of a beta register into specified location. 
| This subroutine zeroes contents of register 31.
| Modify R0 and R1.  <R0> is the source address, <R1> the destination.
	
brload:	ccmp(BR31, R0)
	jne(brloadnot31)
brload31:
	push(R2)
	cmove(0-5, R2)
	cmove(R0, 0)
brload31loop:
	movei(R0, R1)
	cadd(1, R1, R1)
	cadd(1, R2, R2)
	jne(brload31loop)
	pop(R2)
	jmp(brloadend)
brloadnot31:
	call(imovei4)
brloadend:	
	rtn()
	
| Symbol that tells us how much microcode ROM we're using:
END:
ENDHI = END/256                 | MAX VALUE: 0b11111 (= 31 decimal).
