| Beta OS (BOS)
|	
| 30/11/1999 : (JMF) Creation
| 09/12/1999 : (JMF) Continued
	
| To add/remove a program, see the Used/Not Used flag of the Contexts label

	
.include betainstr
.include convbetainstr

	
|===============================================================================|
| Definitions                                                                   |
|===============================================================================|
	
SSVCVEC         = 0x100         | Supervisor call trap vector address
INSTNBR		= 100		| Time Slices lengths
SV_EXIT		= 0		| Interrupt codes
SV_FORK		= 1
SV_GETSEM	= 2
SV_WAIT		= 3
SV_SIGNAL	= 4

	
|===============================================================================|
| Some macros
|===============================================================================|
	
.macro WORD(x)	(x)%256 (x)/256		| Low-byte fol. by high-byte
.macro LONG(x)	WORD(x) WORD(x >> 16)	| Low-word fol. by high-word


|===============================================================================|
| Initialisation
|===============================================================================|
	
kinit:	bcmove(KStack, SP)
	bcmove(0, r(1))			| Add programs to the active
kinitloop:				| programs circular list
	baddc(r(1), 1, r(1))
	bmulc(r(1), CONTEXTSIZE, r(2))
	bld(r(2), Contexts + CONTEXTSIZE - XPSIZE, r(2))
	bbeq(r(2), kinitflagnotset, R31)| Test 'Used/Not Used' flag
kinitflagset:			| Flag set, add the program to the list
	bpush(r(1))
	bbr(ActiveProcAdd, LP)
	bdeallocate(1)
kinitflagnotset:		| Flag not set, try next one (if it exists)
	bcmpeqc(r(1), 7, r(2))	| 'Last program' test
	bbeq(r(2), kinitloop, R31)
	bbr(ActiveProcTop, LP)
	bmulc(r(0), 0x2000, r(0))
	bsetclk(0xFFFF)		| Causes an interrupt
	bjmp(r(0), R31)		| Jump to first program

	
|===============================================================================|
| Datas
|===============================================================================|

|-------------------------------------------------------------------------------|
| ActiveProcList list : holds the active processes
| It's a circular list

ActiveProcNbr:			| Nbr of elements in the ActiveProcList
	LONG(0)
ActiveProcCurrent:		| Current running program
	LONG(0)
ActiveProcList:			| Every running program must be referenced here
Current	= . + 4 * 7		| Max 7 programs (Kernel never runs)

|-------------------------------------------------------------------------------|
| Subroutines related to the ActiveProcList list

ActiveProcTop:			| Returns top element of ActiveProcList
	bld(R31, ActiveProcCurrent, r(0))
	bmulc(r(0), 4, r(0))
	bld(r(0), ActiveProcList, r(0))
	bjmp(LP, R31)
	
ActiveProcRotate:		| Rotates ActiveProcList.  Returns top PID
	bpush(r(1))
	bld(R31, ActiveProcCurrent, r(0))
	bld(R31, ActiveProcNbr, r(1))
	baddc(r(0), 1, r(0))
	bcmpeq(r(0), r(1), r(1))
	bbeq(r(1), ActiveProcRotateEnd, R31)
	bcmove(0, r(0))
ActiveProcRotateEnd:	
	bst(r(0), R31, ActiveProcCurrent)
	bmulc(r(0), 4, r(0))
	bld(r(0), ActiveProcList, r(0))
	bpop(r(1))
	bjmp(LP, R31)

ActiveProcAdd:			| Adds the PID given as an argument to the
	bpush(BP)		| list
	bmove(SP, BP)
	bpush(r(1))
	
	bld(R31, ActiveProcNbr, r(0))
	baddc(r(0), 1, r(0))
	bst(r(0), ActiveProcNbr, R31)
	bsubc(r(0), 1, r(0))
	bmulc(r(0), 4, r(0))
	bld(BP, 0-8, r(1))	| Load argument
	bst(r(1), ActiveProcList, r(0))
	
	bpop(r(1))
	bpop(BP)
	bjmp(LP, R31)		| Retour de procedure	

	
|===============================================================================|
| Interrupt vectors                                                             |
|===============================================================================|
	
Current = SSVCVEC
LONG(hintSV)	LONG(0)	LONG(0) LONG(0)	| Supervisor call
LONG(hintIO)	LONG(0) LONG(0) LONG(0)	| I/O
LONG(hintBUT)	LONG(0) LONG(0) LONG(0)	| Buttons
LONG(hintCLK)	LONG(0) LONG(0) LONG(0)	| Clock

	
|===============================================================================|
| Saved Registers (useful for the Supervisor interrupt handler)                 |
|===============================================================================|
	
SavedRegs:
SavedSP:LONG(0)
SavedLP:LONG(0)
SavedBP:LONG(0)
SavedR0:LONG(0)	
SavedR1:LONG(0)	
SavedR2:LONG(0)

	
|===============================================================================|
| Contexts                                                                      |
|===============================================================================|

Contexts:
CONTEXTSIZE	= 32 * 4	| R0...R30 must be saved in each context
				| The 32nd long word is a flag telling if
				| the process is used or not.
				| To add/remove a program, set/reset the
				| Used flag and add/remove the corresponding
				| .include command after the Progams label
XPSIZE		= 4
FLAGSIZE	= 4

ContextsKernel:
ContextsProg0:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 0
	WORD(0)		WORD(0)			| XP
	LONG(1)					| Flag Used/Not Used
ContextsProg1:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 1
	WORD(0)		WORD(1)			| XP
	LONG(1)					| Flag Used/Not Used
ContextsProg2:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 2
	WORD(0)		WORD(2)			| XP
	LONG(0)					| Flag Used/Not Used
ContextsProg3:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 3
	WORD(0)		WORD(3)			| XP
	LONG(0)					| Flag Used/Not Used
ContextsProg4:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 4
	WORD(0)		WORD(4)			| XP
	LONG(0)					| Flag Used/Not Used
ContextsProg5:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 5
	WORD(0)		WORD(5)			| XP
	LONG(0)					| Flag Used/Not Used
ContextsProg6:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 6
	WORD(0)		WORD(6)			| XP
	LONG(0)					| Flag Used/Not Used
ContextsProg7:
Current = . + CONTEXTSIZE - (XPSIZE + FLAGSIZE)	| Context 7
	WORD(0)		WORD(7)			| XP
	LONG(0)					| Flag Used/Not Used

	
|===============================================================================|
| Interrupt handlers                                                            |
|===============================================================================|

hintSV:				| Supervisor call handler
	bst(SP, SavedSP, R31)	| Get a stack
	bst(LP, SavedLP, R31)	| This interrupt will modify LP
	bst(BP, SavedBP, R31)	| This interrupt will modify BP
	bst(r(0), SavedR0, R31) | This interrupt will modify R0
	bst(r(1), SavedR1, R31) | This interrupt will modify R1
	bst(r(2), SavedR2, R31) | This interrupt will modify R2
	bcmove(KStack, SP)

	bld(R31, SavedSP, r(0))	| Get service num. on the process's stack
	bpush(r(0))
	bcmove(0, r(0))
	bpush(r(0))
	bbr(PIDStackGet, LP)
	bdeallocate(2)

	bcmpeqc(r(0), SV_EXIT, r(1))	| Branch to interrupt handler
	bbne(r(1), hintSV_EXIT, R31)
	bcmpeqc(r(0), SV_FORK, r(1))
	bbne(r(1), hintSV_FORK, R31)
	bcmpeqc(r(0), SV_GETSEM, r(1))
	bbne(r(1), hintSV_GETSEM, R31)
	bcmpeqc(r(0), SV_WAIT, r(1))
	bbne(r(1), hintSV_WAIT, R31)
	bcmpeqc(r(0), SV_SIGNAL, r(1))
	bbne(r(1), hintSV_SIGNAL, R31)
	
hintSV_return:
	bld(R31, SavedSP, SP)	| Restore stack
	bld(R31, SavedLP, LP)	| Restore LP
	bld(R31, SavedBP, BP)	| Restore BP
	bld(R31, SavedR0, r(0))	| Restore R0
	bld(R31, SavedR1, r(1))	| Restore R1
	bld(R31, SavedR2, r(2))	| Restore R2
	bjmp(XP, R31)		| Retour de procedure
	
|-------------------------------------------------------------------------------|
hintSV_EXIT:
	bcmove(0xFFFF, r(0))
	bbr(hintSV_return, R31)

|-------------------------------------------------------------------------------|
hintSV_FORK:			| Kernel Service FORK
	bcmove(0xEEEE, r(0))
	
	bpush(LP)		| Prologue
	bpush(BP)
 	bmove(SP, BP)
	bpush(r(1))
	
	bcmove(1, r(0))
	bcmove(ContextsProg1 + CONTEXTSIZE - FLAGSIZE, r(1))
hintSV_FORK_loop:
	bld(r(1), 0, r(3))
	bbeq(r(3), hintSV_FORK_loop_exit, R31)
	baddc(r(0), 1, r(0))
	baddc(r(1), CONTEXTSIZE, r(1))
	bcmplec(r(0), 7, r(3))
	bbne(r(3), hintSV_FORK_loop, R31)

hintSV_FORK_loop_exit:
	bcmpeqc(r(0), 8, r(1))
	bbeq(r(1), hintSV_FORK_create, R31)
	bcmove(0-1, r(0))
	bbr(hintSV_FORK_end, R31)
	
hintSV_FORK_create:
	bpush(r(0))
	bbr(SwitchFlag, LP)	| Switch Used/Not Used process's flag
	bdeallocate(1)
	|copy (boucle)
	|add to list of active procs
	|copycontext
	|modify xp and return value son/father
	
hintSV_FORK_end:
	bpush(r(0))		| Push return value
	bld(R31, SavedSP, r(0))	| Get register num. on the process's stack
	bpush(r(0))
	bcmove(1, r(0))
	bpush(r(0))
	bbr(PIDStackGet, LP)
	bdeallocate(2)
	bpush(r(0))
	
	bbr(ArgtoRn, LP)	| Save return value in the right register
	bdeallocate(2)

	bpop(r(1))
	bmove(BP, SP)		| Epilogue
	bpop(BP)
	bpop(LP)
	bbr(hintSV_return, R31)

|-------------------------------------------------------------------------------|
hintSV_GETSEM:			| Kernel Service GETSEM
	bcmove(0xDDDD, r(0))
	bbr(hintSV_return, R31)

|-------------------------------------------------------------------------------|
hintSV_WAIT:			| Kernel Service WAIT
	bcmove(0xCCCC, r(0))
	bbr(hintSV_return, R31)
	
|-------------------------------------------------------------------------------|
hintSV_SIGNAL:			| Kernel Service SIGNAL
	bcmove(0xBBBB, r(0))
	bbr(hintSV_return, R31)	

|===============================================================================|
hintIO:				| I/O handler
hintBUT:			| Buttons handler
	bjmp(XP, R31)		| Handler return

|===============================================================================|
hintCLK:			| Clock handler
	bst(SP, SavedSP, R31)	| Get a stack
	bcmove(KStack, SP)
	bpush(LP)
	bbr(SaveContext, LP)	| Pops LP !
	bbr(ActiveProcRotate, LP)	| Returns new PID
	bpush(r(0))		| Argument of RestoreContext = new PID
	bbr(RestoreContext, LP)	| Pops arg., push new LP & modifies SavedSP !
	bpop(LP) bbpt()
	bld(R31, SavedSP, SP)	| Restore stack
	bsetclkc(INSTNBR)
	bjmp(XP, R31)		| Handler return

	
|===============================================================================|
| Subroutines                                                                   |
|===============================================================================|
	
SaveContext:			| Save R0...R30.  SP must be saved in SavedSP
				| Takes LP as an argument
	| WARNING this procedure doesn't use the standard procedure calling
	| agreement.  It modifies R0 and R1 and pops its argument.
	bpush(r(0))		| We'll need R0 to do the job.  Save it
	bpush(LP)
	bbr(ActiveProcTop, LP)	| Put adress of the context of the
	bpop(LP)		| current process in R0
	bmulc(r(0), CONTEXTSIZE, r(0))
	baddc(r(0), Contexts, r(0))

	bst(r(1), 1*4, r(0))	bst(r(2), 2*4, r(0))	bst(r(3), 3*4, r(0))
	bst(r(4), 4*4, r(0))	bst(r(5), 5*4, r(0))	bst(r(6), 6*4, r(0))
	bst(r(7), 7*4, r(0))	bst(r(8), 8*4, r(0))	bst(r(9), 9*4, r(0))
	bst(r(10), 10*4, r(0))	bst(r(11), 11*4, r(0))	bst(r(12), 12*4, r(0))
	bst(r(13), 13*4, r(0))	bst(r(14), 14*4, r(0))	bst(r(15), 15*4, r(0))
	bst(r(16), 16*4, r(0))	bst(r(17), 17*4, r(0))	bst(r(18), 18*4, r(0))
	bst(r(19), 19*4, r(0))	bst(r(20), 20*4, r(0))	bst(r(21), 21*4, r(0))
	bst(r(22), 22*4, r(0))	bst(r(23), 23*4, r(0))	bst(r(24), 24*4, r(0))
	bst(r(25), 25*4, r(0))	bst(r(26), 26*4, r(0))	bst(r(27), 27*4, r(0))
							bst(r(30), 30*4, r(0))

	bld(R31, SavedSP, r(1))	| Put SavedSP in context
	bst(r(1), 29*4, r(0))
	bpop(r(1))		| Put R0 in context
	bst(r(1), 0*4, r(0))
	bpop(r(1))		| Put LP in context
	bst(r(1), 28*4, r(0))
	bjmp(LP, R31)

RestoreContext:			| Restore R0...R30
				| Takes new PID as an argument
	| WARNING this procedure doesn't use the standard procedure calling
	| agreement.  It modifies all registers (except LP), pops its argument
	| and push a new LP on the stack.
	bpop(XP)		| Get the context of the program to restore
	bmulc(XP, CONTEXTSIZE, XP)
	baddc(XP, Contexts, XP)

	bld(XP, 29*4, r(1))	| Put new SP in Saved SP
	bst(r(1), SavedSP, R31)

	bld(XP, 28*4, r(1))	| Push new LP
	bpush(r(1))
	
	bld(XP, 0*4, r(0))	| Don't restore LP and SP
	bld(XP, 1*4, r(1))	bld(XP, 2*4, r(2))	bld(XP, 3*4, r(3))
	bld(XP, 4*4, r(4))	bld(XP, 5*4, r(5))	bld(XP, 6*4, r(6))
	bld(XP, 7*4, r(7))	bld(XP, 8*4, r(8))	bld(XP, 9*4, r(9))
	bld(XP, 10*4, r(10))	bld(XP, 11*4, r(11))	bld(XP, 12*4, r(12))
	bld(XP, 13*4, r(13))	bld(XP, 14*4, r(14))	bld(XP, 15*4, r(15))
	bld(XP, 16*4, r(16))	bld(XP, 17*4, r(17))	bld(XP, 18*4, r(18))
	bld(XP, 19*4, r(19))	bld(XP, 20*4, r(20))	bld(XP, 21*4, r(21))
	bld(XP, 22*4, r(22))	bld(XP, 23*4, r(23))	bld(XP, 24*4, r(24))
	bld(XP, 25*4, r(25))	bld(XP, 26*4, r(26))	bld(XP, 27*4, r(27))
							bld(XP, 30*4, r(30))
	
	bjmp(LP, R31)
	
|-------------------------------------------------------------------------------|
PIDStackGet:			| Get the (arg1+1)-th element of the current
	bpush(LP)		| running process's stack.
	bpush(BP)		| arg2 is the current running process's SP
	bmove(SP, BP)
	bpush(r(1))
	bpush(r(2))
	
	bbr(ActiveProcTop, LP)	| Get current active process
	bld(BP, 0-16, r(1))	| Get current active process's SP
	bld(BP, 0-12, r(2))	| Get arg1 of PIDStackGet
	baddc(r(2), 1, r(2))
	bmulc(r(2), 4, r(2))
	bsub(r(1), r(2), r(1))
	bandc(r(1), 0x1FFF, r(1))
	bshlc(r(0), 13, r(0))
	bor(r(0), r(1), r(1))
	bld(r(1), 0, r(0))
	
	bpop(r(2))
	bpop(r(1))
	bpop(BP)
	bpop(LP)
	bjmp(LP, R31)		| Routine's return

|-------------------------------------------------------------------------------|
SwitchFlag:			| Switch the Used/not used flag of the
	bpush(LP)		| process given as an argument.
	bpush(BP)		| Prologue
	bmove(SP, BP)
	bpush(r(0))
	bpush(r(1))

	bld(BP, 0-12, r(0))	| Load the argument.
	bmulc(r(0), CONTEXTSIZE, r(0))
	bld(r(0), ContextsKernel + CONTEXTSIZE - FLAGSIZE, r(1))
	bxorc(r(1), 0x01, r(1))
	bst(r(1), ContextsKernel + CONTEXTSIZE - FLAGSIZE, r(0))
	
	bpop(r(1))		| Epilogue
	bpop(r(0))
	bpop(BP)
	bpop(LP)
	bjmp(LP, R31)		| Routine's return
	
|-------------------------------------------------------------------------------|
ArgtoRn:			| Save the number given as the second argument
	bpush(LP)		| to the register r(arg1) (arg1 being the first
	bpush(BP)		| argument).
	bmove(SP, BP)		| The registers R0...R2, LP, BP and SP are
	bpush(r(0))		| special cases : their values are held in
	bpush(r(1))		| SavedR0... SavedSP (resp.).

	
	bld(BP, 0-12, r(0))	| Load register number (first arg.)
	bmulc(r(0), 8, r(0))	| Computes an offset in the savetable table
	baddc(r(0), ArgtoRn_savetable, r(0))
	bcmove(0x01, r(1))	| We want to stay in privilege mode
	bshlc(r(1), 31, r(1))	| Privilege bit is the 32th
	bor(r(0), r(1), r(0))
	bld(BP, 0-16, r(1))	| Load code to save (second arg.)
	bjmp(r(0), R31)
	
ArgtoRn_savetable:
	bst(r(0), 0, SavedR0)			bbr(ArgtoRn_end, R31)
	bst(r(1), 0, SavedR1)			bbr(ArgtoRn_end, R31)
	bst(r(2), 0, SavedR2)			bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bmove(r(1), r((.-ArgtoRn_savetable))/8)	bbr(ArgtoRn_end, R31)
	bst(BP, 0, SavedBP)			bbr(ArgtoRn_end, R31)
	bst(LP, 0, SavedLP)			bbr(ArgtoRn_end, R31)
	bst(SP, 0, SavedSP)			bbr(ArgtoRn_end, R31)
	baddc(R31, 0, R31)			bbr(ArgtoRn_end, R31)
	baddc(R31, 0, R31)			bbr(ArgtoRn_end, R31)
	
ArgtoRn_end:
	bpop(r(1))		| Epilogue
	bpop(r(0))
	bpop(BP)
	bpop(LP)
	bjmp(LP, R31)		| Routine's return

	
|===============================================================================|
| Top of Kernel Stack                                                           |
|===============================================================================|

KStack:

	
|===============================================================================|
| Running Programs                                                              |
|===============================================================================|
	
Programs:
	
Current	= 0x2000
Prog1:
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(2, r(0))
	bpush(r(0))
	bcmove(SV_FORK, r(0))
	bpush(r(0))
	bsvcall()
	bbpt()
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
	bcmove(sstack, SP)
sstack:	
	|.include betafibo
	
Current	= 0x4000
Prog2:
	
Current	= 0x6000	
Prog3:
	
Current	= 0x8000	
Prog4:
	
Current	= 0xA000	
Prog5:
	
Current	= 0xC000			
Prog6:
	
Current	= 0xE000		
Prog7:
