/*
 * Fichier:ctlrom.c
 * Fentre sur la rom de contrle pour l'mulateur MAYBE
 */

#include <stdio.h>
#include <stdlib.h>

#include "maysim.h"
#include "display.h"
#include "mayfile.h"
#include "maywin.h"
#include "memwin.h"
#include "machine.h"
#include "hard.h"
#include "ctlrom.h"

int NotifyCtlRomWin(CtlRomWin *,Event *);
void DisplayCtlRomWin(CtlRomWin *);

WinClass CtlRomWinClass={
4,
2, /* lgende et status + une ligne de donnes */
MAXUINT,
CreateCtlRomWin,
(DisplayFunPtr)DisplayCtlRomWin,
(NotifyFunPtr)NotifyCtlRomWin
};

#define MaxCtlRomWins	MAXWINS
CtlRomWin CtlRomWins[MaxCtlRomWins];

Win *CreateCtlRomWin(){
	CtlRomWin *winptr;
	unsigned int i;
	boolean track;
	/* Cherche une fentre disponible */
	for(i=0;i<MaxCtlRomWins;i++)
		if( CtlRomWins[i].Height==0 ){
			winptr=&CtlRomWins[i];
			winptr->WinClass0=&CtlRomWinClass;
			winptr->Height=CtlRomWinClass.DefaultHeight;
			winptr->DisplayMode=CRTL;
			winptr->StartAddr=0;
			track=i==0;
			while( track && ++i<MaxCtlRomWins )
				track=CtlRomWins[i].Height==0
					|| CtlRomWins[i].AutoTrack==FALSE;
			winptr->AutoTrack=track;
			winptr->ShowHead=1;
			return((Win*)winptr);
		}
	return(0);
}

/* Traduction des codes de registre hardware source en noms symboliques */
char *DRSEL[8]={"Switches","MicroRom","ALU  == ","011 N.C.","SRAM    ",
"101 N.C.","DRAM    ","I/O Data"};
/* Traduction des codes de registre hardware destination en noms symboliques */
char *LDSEL[8]={"Opcode  ","ADR     ","A       ","B       ","SRAM    ",
"MAR     ","DRAM    ","I/O Data"};

/* Affiche une ligne de la rom de contrle en hexa et en RTL */
unsigned int DumpCtl( unsigned int k ){
	byte lobyte,hibyte;
	byte *kaddr;
	int i=1;
	kaddr=(byte *)(CtlRom + k);
	lobyte=CtlRom[k] & 0xff;       /* lobyte=*kaddr; */
	hibyte=CtlRom[k] >> 8;         /* hibyte=*(kaddr+1); */
	/* Tentons de grouper les lignes egales */
	if( k&1 ){
		putchari('T');
	}else{
		if( CtlRom[k]==CtlRom[k+1] ){
			putchari('*');i++;
		}else{
			putchari('F');
		}
	}
	printfi(" = %2.2X:%2.2X ",hibyte,lobyte);
	if (hibyte&0x80)
		putsi("PC++ ");
	else
		putsi("     ");
	switch(lobyte&0xc0){
		case 0x00:
			putsi("Load CC  ");
			break;
		case 0x40:
			putsi("Shift CC ");
			break;
		default:
			putsi("Same CC  ");
			break;
	}
	putsi(LDSEL[lobyte&7]);
	putsi(" <- ");
	putsi(DRSEL[(lobyte>>3)&7]);
	putsi("  ");
	/* printfi("%2.2d ",((hibyte>>3)&15)+
		(hibyte&2?32:hibyte&4<<2)); */
	putsi(ALUOpName[((hibyte>>3)&15)+(hibyte&2?32:hibyte&4<<2)]);
	return(i);
}
/* Affiche une fentre sur la rom de contrle */
void DisplayCtlRomWin(CtlRomWin *winptr){
	unsigned int i,k,imin=0,y;
	boolean gothead=0,needhead,track;
	char flags[]="[--]";
	CtlRomDisplayMode dmode;
	DumpFunPtr dumpfptr;
	dmode=winptr->DisplayMode;
	dumpfptr=(dmode==CBIN)?DumpBin:DumpHex;
	track=winptr->AutoTrack;
	needhead=winptr->ShowHead;
	if( track ) flags[1]='T';
	if( needhead) flags[2]='H';
	Title("Nano-code (control roms)",flags);
	k=track?(OpReg<<5)+(PhaseReg<<1):winptr->StartAddr;
	if( dmode==CRTL ){ /* Affiche la lgende */
		putsi("op:p c = hi:lo      Cond     Dest.    <- Source    "
		"Function");
		imin++;
		NextWinLine();
	}else{ /* Aligne le mot de dpart sur la condition F */
		k&=0xFFFE;
	}
	/* boucle sur les lignes affiches */
	for( i=winptr->Height; i>imin; i--){
		if( k<CtlRomSize ){
			if( (k&0x1f)==0 && needhead && !gothead
			    && Headers[k>>5]!=NULL ){
				putsi(Headers[k>>5]);
				gothead=TRUE;
			}else{
				gothead=FALSE;
				printfi("%2.2X:%1.1X ",k>>5,(k>>1)&15);
				if( dmode==CRTL ){
					k+=DumpCtl(k);
				}else{
					k+=(*dumpfptr)((byte*)&CtlRom[k],
					    CtlRomTop)/2;
				}
			}
		}
		NextWinLine();
	}
}

int NotifyCtlRomWin(CtlRomWin *winptr,Event *Event0){
	unsigned long int addr,addr2,maxaddr;
	unsigned int linesize,height,pagesize,key;
	boolean track,dirty;
	CtlRomDisplayMode dmode;
	addr=(long)winptr->StartAddr;
	track=winptr->AutoTrack;
	dirty=winptr->Dirty;
	dmode=winptr->DisplayMode;
	linesize=dmode==CBIN?4:dmode==CHEX?8:2;
	height=winptr->Height-1;
	pagesize=height*linesize;
	maxaddr=(long)(CtlRomSize-2);
	switch(Event0->Type){
	case Cycle:
	case PCUpdate:
	case OpcodeUpdate:
	case PhaseUpdate:
		dirty=track; /* Reflte le changement si ncessaire */	
		break;
	case CtlRomUpdate:
		dirty=TRUE; /* Vrification d'adresse ?? */
		break;
	case KeyPress:
		key=Event0->Val;
		switch(key){
		case PageUpKey:
			if ( !track ){
				if( dmode==CRTL ){
					if( addr&31 )
						addr&=0xFFE0;
					else
						if( addr ) addr-=32;
				}else{
					if( addr>pagesize )
						addr-=pagesize;
					else
						addr=0;
				}
				dirty=TRUE;
			}
			break;
		case PageDownKey:
			if ( !track && addr<maxaddr ){
				if( dmode==CRTL ){
					if( addr&31 ) addr&=0xFFE0;
					addr+=32;
				}else{
					addr+=pagesize;
				}
				if(addr>maxaddr) addr=maxaddr;
				dirty=TRUE;
			}
			break;
		case 't':
		case 'T':
			winptr->AutoTrack=!track;
			dirty=TRUE;
			break;
		case 'h':
		case 'H':
			winptr->ShowHead^=TRUE;
			dirty=TRUE;
			break;
		case ' ':				
			dmode++;
			if( dmode>CRTL ) dmode=CBIN;
			winptr->DisplayMode=dmode;
			dirty=TRUE;
			break;
		case 'o':
		case 'O':
			addr2=GetBVal("Opcode?",OpReg)<<5;
			if( ErrFlag ) break;
			if( addr2<maxaddr ){
				winptr->AutoTrack=FALSE;
				addr=addr2;
				dirty=TRUE;
				PutStatus(IdleStatus);
			}else{
				Error(RangeErr);
			}
			break;
		default:
			switch(VScroll(key,&addr,maxaddr,linesize,height)){
			case 1: /* On a boug */
				dirty=TRUE;
				winptr->AutoTrack=FALSE;
				break;
			case 0: /* On a voulu bouger mais on n'a pas pu */
				break;
			default: /* On n'a pas reconnu la touche */
				return(FAIL);
			}
		}
		winptr->StartAddr=(unsigned int)(addr&0xFFFFFFFE);
		break;
	default: /* Evnement inconnu */
		return(FAIL);
	}
	winptr->Dirty=dirty;
	return(OK);
}
