/*
 * Fichier:display.c
 * affichage texte orient ligne pour l'mulateur MAYBE
 *
 * Lorsque c'tait possible, la vitesse a t amliore par l'emploi
 * de tableaux de char, ceci vitant de multiples appels  printf().
 * 
 */

#include <stdio.h>

#include "maysim.h"
#include "machine.h"
#include "display.h"

char MsgBuf[TW];
char* IntErr="MAYSIM: Internal error, please report to developer";
char* RangeErr="Out of range";

/* Transforme un entier long non sign en chane de chiffres dcimaux */
char *ultod(unsigned long u, char *dest)
{
	register int i=0,j;
	char c;
	do{ /* Au moins un caractre, mme si c'est '0' */
		dest[i++]='0'+(u%10);
		u/=10;
	}while(u);
	dest[i]=0;
	/* Maintenant que la longueur est connue, on peut rordonner */
	for(j=0, i--; j<i; j++, i--){
		c=dest[j];
		dest[j]=dest[i];
		dest[i]=c;
	}
	return(dest);
}

void PutBit(char *bitname, boolean bitval){
	putsi(bitname);
	putsi(bitval?"=1 ":"=0 ");
}

static char binout[]="00000000 ";
void PutBin( byte b ){
	register byte c;
	c=b;
	/* Boucle droule pour la vitesse */
	binout[7]=(c&1)+'0';c>>=1;
	binout[6]=(c&1)+'0';c>>=1;
	binout[5]=(c&1)+'0';c>>=1;
	binout[4]=(c&1)+'0';c>>=1;
	binout[3]=(c&1)+'0';c>>=1;
	binout[2]=(c&1)+'0';c>>=1;
	binout[1]=(c&1)+'0';c>>=1;
	binout[0]=c+'0';
	putsi(binout);
}

unsigned int DumpBin( byte *mem, byte *memtop ){
	signed long int k;
	unsigned int l;
	k=(unsigned long)memtop-(unsigned long)mem;
	if( k<0 ){ fputs(IntErr,stderr); ExitProgram(-1); }
	if( k>7 ) k=7;
	l=(unsigned int)k+2;
	while(--l) PutBin(*mem++);
	return((unsigned int)k+1);
}

char HexDigits[]="0123456789ABCDEF";
static char hexout[]=
	"00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................";
char *DumpSeparator=hexout+16*3-1;
char *SDumpHex( byte *mem, byte *memtop){
	signed long int k;
	unsigned int i=0,j=48,l;
	byte c;
	k=(unsigned long)memtop-(unsigned long)mem;
	if( k<0 ){ fputs(IntErr,stderr); ExitProgram(-1); }
	if( k>15 ) k=15;
	l=(unsigned int)k+2;
	while(--l){
		c=*mem++;
		hexout[i++]=HexDigits[c>>4];
		hexout[i++]=HexDigits[c&0x0F];
		i++;
		hexout[j++]=(c>31 && c<128)?c:'.';
	}
	while(i<48){ hexout[i++]=' ';hexout[i++]=' '; i++; }
	hexout[j]=0;
	return(hexout);
}
unsigned int DumpHex( byte *mem, byte *memtop){
	putsi(SDumpHex(mem, memtop));
	return(16);
}
int HexDigit( int c ){
	if( c>='0' && c<='9' ) return(c-'0');
	if( c>='A' && c<='F' ) return(c-'A'+10);
	if( c>='a' && c<='f' ) return(c-'a'+10);
	return(-1);
}

int EditHex( byte *mem, unsigned long offset, unsigned long limit,
		int x, int y, unsigned int digitval){
	unsigned int digitnum;
	byte b;
	digitnum=x%3;
	if( digitnum<2 && x>=0 && x<48 && y>=0 ){
		offset+=x/3+y*16;
		if( offset<limit ){
			b=mem[offset];
			if( digitnum ){
				b=(b&0xF0)+digitval;
			}else{
				b=(b&0x0F)+(digitval<<4);
			}
			mem[offset]=b;
			return(1+digitnum);
		}else{
			Error(RangeErr);
		}
	}else{
		Error("Cannot edit this field");
	}
	return(0);
}

int EditBin( byte *mem, unsigned long offset, unsigned long limit,
		int x, int y, unsigned int digitval){
	unsigned int digitnum;
	byte b;
	digitnum=x%9;
	if( digitnum<8 && x>=0 && x<72 && y>=0 ){
		offset+=x/9+y*8;
		if( offset<limit ){
			if( digitval )
				mem[offset]|=0x80>>digitnum;
			else
				mem[offset]&=~(0x80>>digitnum);
			return(1+(digitnum==7));
		}else{
			Error(RangeErr);
		}
	}else{
		Error("Cannot edit this field");
	}
	return(0);
}

/*************************************
 * Affichage d'un chapeau de fentre *
 *************************************/
 
static char HorSeparator[]="========================================"
			   "========================================";

void Title(char *Title,char *Stat){
	int i;
	i= strlen(Title);
	i= TW+((i>TW)?TW:i);
	putsi(&HorSeparator[i/2]);
	putsi(Title);
	if( Stat ){
		putsi(&HorSeparator[strlen(Stat)+(i+1)/2]);
		putsi(Stat);
	}else{
		putsi(&HorSeparator[(i+1)/2]);
	}
	if( WrapMode ) return;
	putchari('\n');
}

