/*
 * Fichier:dram.c
 * Fentre sur la ram dynamique pour l'mulateur MAYBE
 */

#include <stdio.h>
#include "maysim.h"
#include "display.h"
#include "maywin.h"
#include "memwin.h"
#include "machine.h"
#include "hard.h"
#include "dram.h"

int NotifyDRamWin(DRamWin *,Event *);
void DisplayDRamWin(DRamWin *);

WinClass DRamWinClass={
3,
1,
MAXUINT,
CreateDRamWin,
(DisplayFunPtr)DisplayDRamWin,
(NotifyFunPtr)NotifyDRamWin
};

#define MaxDRamWins	MAXWINS
DRamWin DRamWins[MaxDRamWins];

Win *CreateDRamWin(){
	DRamWin * DRamWinPtr;
	unsigned int i;
	for(i=0;i<MaxDRamWins;i++)
		if( DRamWins[i].Height==0 ){
			DRamWinPtr=&DRamWins[i];
			InitMemWin((MemWin *)DRamWinPtr,&DRamWinClass);
			return((Win*)DRamWinPtr);
		}
	return(0);
}

void DisplayDRamWin(DRamWin *DRamWin0){
	unsigned int i;
	unsigned long int k;
	char c;
	DumpFunPtr dumpfptr;
	dumpfptr=(DRamWin0->DisplayMode==MBIN)?DumpBin:DumpHex;
	Title("Core memory (dynamic ram)",0);
	k=(long)DRamWin0->StartAddr;
	for(i=0;i<DRamWin0->Height;i++){
		if(k<DRamSize){
			printfi("%4.4X ",(int)k);
			k+=(*dumpfptr)(&DRam[k],DRamTop);
		}
		NextWinLine();
	}
}

int NotifyDRamWin(DRamWin *winptr,Event *evptr){
	unsigned long int addr,maxaddr;
	unsigned int linesize=16,height;
	int rc;
	boolean dirty;
	MemDisplayMode dmode;
	dirty=winptr->Dirty;
	addr=(long)winptr->StartAddr;
	dmode=winptr->DisplayMode;
	if(dmode==MBIN) linesize=8;
	maxaddr=(long)(DRamSize-linesize);
	height=winptr->Height-1;
	switch(evptr->Type){
	case Cycle:
	case DRamUpdate:
		dirty=TRUE;
		break;
	case KeyPress:
		switch(evptr->Val){
		case ' ':
			winptr->DisplayMode=(dmode==MBIN)?MHEX:MBIN;
			addr&=(dmode==MBIN)?0xFFF0:0xFFF8;
			dirty=TRUE;
			break;
		default:
			rc=VScroll(evptr->Val,&addr,maxaddr,linesize,height);
			if(rc>=0){
				dirty=rc;
			/*	CtlRomWin0->AutoTrack=FALSE; */
			}else{
				rc=EditMem(DRam,(long)(winptr->StartAddr),
					(long)DRamSize,evptr->Val,dmode,5);
				if( rc>0 ){
					dirty=TRUE;
					Broadcast(&DRamEvent);
					CurX+=rc;
				}else{
					if( rc<0 ) return(FAIL);
				}
			}
		}
		winptr->StartAddr=(unsigned int)addr;
		break;
	default:
		return(FAIL);
	}
	winptr->Dirty=dirty;
	return(OK);
}

