/*
 * Fichier:hard.h
 * voir hard.c pour les commentaires
 */

extern byte OpReg,PhaseReg;

extern int AReg,BReg,ALUReg;
extern byte CCode,CCodeReg;
typedef void ALUFun();
extern char *ALUOpName[48];
extern ALUFun* ALUFuns[128];

extern byte Switches,Buttons;
#define BUTTONMASK	(16)

/* Image mot pour mot des mmoires
 * La rom de contrle est la seule mmoire dont les mots font 16 bits,
 * les autres contiennent des bytes (8 bits).
 */
#define	CtlRomSize	(8192)
extern unsigned int CtlRom[CtlRomSize];
extern byte *CtlRomTop;
/* extern byte CtlRomLo[CtlRomSize];
extern byte CtlRomHi[CtlRomSize]; */

#define MicroRomSize	(8192)
extern byte MicroRom[MicroRomSize];
extern byte *MicroRomTop;
extern unsigned int PCReg,PCTrack;

#define	SRamSize (256)
extern byte SRam[SRamSize];
extern byte *SRamTop;
extern byte MAReg;

#define DRamSize (65536)
extern byte DRam[DRamSize];
extern byte *DRamTop;

/* UART 8250 */
extern byte RBR,THR,IER,IIR,LCR,MCR,LSR,MSR,DivLatchLo,DivLatchHi;
extern byte CTS,DSR,RI,RLSD;
extern char OutBuf[];
extern int OutCol;

void Jump( unsigned int );
void Reset();
void NanoStep( unsigned long int );
extern int BreakOp[256];

void InitHard();
