/*
 * Fichier: kbplain.h
 * Codes de touches accessibles par tout clavier ASCII
 * Utilisable par toute les versions MAYSIM
 */

/* 26/11/1999 (JMF) : Redefinition du Return & RunKey */

/************************************************
 * Codes des touches du clavier gnrique ASCII *
 ************************************************/

#define PLAIN_KEYBOARD
 
#define Ctrl( c )	(31&c)

/*
 * La touche <Esc> ne convient pas bien comme touche Meta parce que
 * <Esc> est aussi le prfixe utilis par certains terminaux pour les
 * touches spciales. On a donc pris Ctrl-X pour viter les conflits.
 */
#define	MetaKey		Ctrl('X')
#define Meta( c )	((MetaKey<<8)+c)

/***** Touches utilises par le gestionnaire de fentres */

/* Mouvement du curseur dans les fentres */
#define UpKey		Ctrl('P') /* Previous */
#define DownKey		Ctrl('N') /* Next */
#define LeftKey		Ctrl('B') /* Backward */
#define RightKey	Ctrl('F') /* Forward */
#define	HomeKey		Ctrl('A')
#define	EndKey		Ctrl('E')

/* Contrle des fentres */

#define RefreshKey	Ctrl('L')
#define	EnlargeKey	Meta('+')
#define	ShrinkKey	Meta('-')
#define ZoomKey		Ctrl('Z')
#define	CloseKey	Ctrl('K')

/*
 * Saisie d'une ligne
 * Ces touches peuvent tre rutilises dans un autre contexte
 */

#define	EnterKey	'\n' /*Ctrl('M')*/
#define	QuoteKey	Ctrl('Q')
#define	BSKey		Ctrl('H')
#define DelKey		(0x7F)
#define AbortKey	Ctrl('G')
#define KillKey		Ctrl('K')

/******  Touches gres par l'application */

#define ResetKey	Meta('R')
#define OpenKey		Ctrl('O')
#define QuitKey		Ctrl('Q')
#define ReadKey		Ctrl('R')
/* #define SearchKey	Ctrl('S') */
#define WriteKey	Ctrl('W')
#define Button0Key	Meta('0')
#define Button1Key	Meta('1')
#define DILSwitchKey	Meta('D')
#define GHelpKey	('?')
/* #define LHelpKey	Meta('?') */
#define GoKey		Meta('G')
#define NanoStepKey	Meta('S')
#define BreakPointKey	Meta('B')
#define StepKey		'\n' /* Ctrl('M') Enter */

/* Touches reconnues par la mthode (memwin.c) */
#define TopKey		(Meta('<'))
#define BottomKey	(Meta('>'))
#define ScrollUpKey	('-')
#define ScrollDownKey	('+')
#define PageUpKey	('<')
#define PageDownKey	('>')
#define GotoKey		('=')
#define RunKey          ('W')
