/*
 * fichier:machsun.c (destin a remplacer machine.c dans la version SUN)
 * Entres-sorties dpendantes de la machine, version SUN sous CURSES
 */

#include <stdio.h> /* #include <conio.h> non disponible unix */
#include <curses.h>

/* Vu le conflit de noms entre la macro refresh() de curses
 * et la macro de MAYSIM, il faut definir Refresh0 AVANT l'include suivant.
 */
void Refresh0()
{
  refresh();
}

#include "maysim.h"
#include "machine.h"
#include "kb.c"

/*
 * Ces deux fonctions doivent tre appeles respectivement avant et aprs
 * toute utilisation en mode interactif.
 */

static int InitFlag=0;

void InitMachine() 
{ 	
  initscr();		/* initialize curses */ 	
  noecho(); 	
  raw(); 	
  clear();
  InitFlag=1;
  if(!ForcedHeight) TermHeight=LINES;
}

void ExitMachine()
{
  if( !InitFlag ) return;
  refresh();
  noraw();
  echo();
  endwin();
}

/*
 * Lecture d'une touche (sans attendre CR)
 */

int GetKey(){
  int i,j,k,l,m;
  refresh();
  i=getch();
  if( i==MetaKey) i=Meta(toupper(getch()));
#ifndef PLAIN_KEYBOARD
  /* Convertit les squences de touches spciales en un code 16 bits */
  if( i==0x1b ){ /* Prefixe Esc */
    j=getch();
    if( j==0x5b ){ /* Prefixe 'clavier tendu' */
      k=getch();
#ifdef SUNFKEYS
      if( k==0x32 || k==0x35 || k==0x36 ){
	l=getch();
	if( l==0x32 || l==0x33 ){
	  m=getch();
	  getch();
	  i=(l<<8)+m;
	}else{
	  if( l==0x7a ){
	    i=(j<<8)+k;
	  }else{
	    i=(k<<8)+l;
	  }
	}
#else
      if( k==0x31 || k==0x32 ){
	l=getch();
	if( l!=0x7e ){ /* Terminateur */
	  m=getch();
	}
	i=(k<<8)+l; /* Toujours 31nn ou 32nn */
#endif
      }else{
      	i=(j<<8)+k; /* Toujours 5bnn */
      }
    }else{
      i=(i<<8)+j; /* Toujours 1bnn=6912+n */
    }
  }
#endif
#ifdef KEYMAP
  if(i>255){ /* Codes tendus */
    j=0;
    while( (k=KEYMAP[j]) && k!=i ) /* k=... vaut k vrai si k!=0 */
      j+=2;
    if( k ) i=KEYMAP[j+1];
  }
#endif
  return(i); /* Touche normale, toujours 00nn ou METAnn */
}

/*
 * Gestion de l'affichage du curseur
 * Ncessite la prsence des librairies CURSES
 */
 
void GotoXY(unsigned int X,unsigned int Y){
  move((short)Y,(short)X);
}

void ClEol(){
	clrtoeol(); /* clrtoeol est une macro de curses */
}

void addchfun(char c)
{
  addch(c); /* addch est une macro de curses */
}

void addstrnocr(char *s){
  addstr(s);
}

void addstrcr(char *s){
  addstr(s);
  addch('\n');
}

void NextWinLine(){
  addch((short)'\n');
}

unsigned int Mute=0;
void Bell(){
#ifdef SYSV
	if(!Mute) beep();
#endif
}



















