/*
 * Fichier:maywin.h
 * Dclarations relatives au fentrage horizontal pour l'mulateur MAYBE
 *
 */

#include	<stdio.h>

#include	"status.h"

/* Nombre maximum de fentres ouvertes simultanment */
#define	MAXWINS		(20)
extern char *NoRoomMsg;

/* Les fonctions suivantes doivent tre dfinies pour tout type de fentre */
typedef void(*DisplayFunPtr)(struct WinStr*);
typedef int(*NotifyFunPtr)(struct WinStr*,struct EventStr*);
typedef struct WinStr*(*CreateFunPtr)();

/* La structure suivante est commune  une classe de fentres */
typedef struct {
unsigned int DefaultHeight;
unsigned int MinHeight;
unsigned int MaxHeight;
CreateFunPtr Create;
DisplayFunPtr Display;
NotifyFunPtr Notify;
} WinClass;

/* Toute fentre doit contenir ces deux champs en premier */
#define WINDOW 	WinClass *WinClass0; unsigned int Height; boolean Dirty;

/* Accesseur gnral aux fentres */
typedef struct WinStr {
	WINDOW
} Win;

/*
 * Fonctions pour la gestion des fentres, appelables par l'application
 */
 
void InitWins();
void OpenWin(Win *);

void ShowWins();
int FreeWinLines();
void MarkAll();

/*
 * Gestion de l'affichage dans les fentres
 */

extern unsigned int CurX;
int RelY();

/*
 * Dfinition des vnements
 */

typedef enum {
	KeyPress,
	/* On pourrait tendre la liste  MouseClick, TimeOut, MouseMove... */
	RegUpdate,PCUpdate,OpcodeUpdate,PhaseUpdate,
	SRamUpdate,DRamUpdate,CtlRomUpdate,MicroRomUpdate,
	Cycle
} EventType;


typedef struct EventStr {
EventType Type;
unsigned int X,Y;
unsigned int Val;
} Event;

extern Event PCEvent;
extern Event OpcodeEvent;
extern Event PhaseEvent;
extern Event RegEvent;
extern Event SRamEvent;
extern Event DRamEvent;
extern Event CycleEvent;

void EventLoop();

extern unsigned int NotifyApp(Event *);
unsigned int Dispatch(Event *);
void Broadcast(Event *);



