/*
 * Fichier:memwin.c
 * Fonctions communes aux fentres sur la mmoire
 */

#include "maysim.h" 
#include "maywin.h"
#include "display.h"
#include "machine.h"
#include "memwin.h"

void InitMemWin( MemWin *winptr, WinClass *winclassptr ){
	winptr->WinClass0=winclassptr;
	winptr->Height=winclassptr->DefaultHeight;
	winptr->StartAddr=0;
	winptr->DisplayMode=MHEX;
}

int EditMem( byte *mem, unsigned long offset, unsigned long limit,
		unsigned int key, MemDisplayMode dmode, unsigned int margin){
	int d;
	if( dmode==MHEX && key<0x7F && (d=HexDigit(key))>=0 )
		return(EditHex(mem,offset,limit,CurX-margin,RelY()-1,d));
	if( dmode==MBIN && ( key=='0' || key=='1' ) )
		return(EditBin(mem,offset,limit,CurX-margin,RelY()-1,key-'0'));
	return(-1);
}

/**********************************************************
 * Scrolling vertical  l'intrieur d'une fentre mmoire *
 * Valeur de retour: 1=boug, 0=pas boug, -1=pas reconnu *
 **********************************************************/

int VScroll( unsigned int key,
	     unsigned long *addrptr, unsigned long maxaddr,
	     unsigned int bpl, unsigned int lpp ){
	unsigned long newaddr,inaddr;
	newaddr=*addrptr;
	switch( key ){
	case PageUpKey:
		if( newaddr>bpl*lpp ){
			newaddr-=bpl*lpp;
		}else{
			newaddr=0;
		}
		break;
	case PageDownKey:
		if( newaddr+bpl*lpp<maxaddr ){
			newaddr+=bpl*lpp;
		}else{
			newaddr=maxaddr;
		}
		break;
	case ScrollUpKey:
		if( newaddr>bpl ){
			newaddr-=bpl;
		}else{
			newaddr=0;
		}
		break;
	case ScrollDownKey:
		if( newaddr+bpl<maxaddr ){
			newaddr+=bpl;
		}else{
			newaddr=maxaddr;
		}
		break;
	case TopKey:
		newaddr=0;
		break;
	case BottomKey:
		newaddr=maxaddr;
		break;
	case GotoKey:
		inaddr=(long)GetVal("Goto?");
		if( ErrFlag ) break;
		if( newaddr<=maxaddr ){
			newaddr=inaddr;
			PutStatus(IdleStatus);
		}else{
			Error(RangeErr);
		}
		break;
	default:
		return(-1);		
	}
	if( newaddr==*addrptr ) return(0); /* Pas de changement */
	*addrptr=newaddr;
	return(1);
}
