/*
 * Fichier:microrom.c
 * Fentre sur la rom microcode pour l'mulateur MAYBE
 */

#include <stdio.h>
#include "maysim.h"
#include "display.h"
#include "maywin.h"
#include "memwin.h"
#include "machine.h"
#include "hard.h"
#include "microrom.h"

int NotifyMicroRomWin(MicroRomWin *,Event *);
void DisplayMicroRomWin(MicroRomWin *);

WinClass MicroRomWinClass={
3,
1,
MAXUINT,
CreateMicroRomWin,
(DisplayFunPtr)DisplayMicroRomWin,
(NotifyFunPtr)NotifyMicroRomWin
};

#define MaxMicroRomWins	MAXWINS
MicroRomWin MicroRomWins[MaxMicroRomWins];

Win *CreateMicroRomWin(){
	MicroRomWin * winptr;
	unsigned int i;
	boolean track;
	for(i=0;i<MaxMicroRomWins;i++)
		if( MicroRomWins[i].Height==0 ){
			winptr=&MicroRomWins[i];
			InitMemWin((MemWin *)winptr,&MicroRomWinClass);
			track=i==0;
			while( track && ++i<MaxMicroRomWins )
				track=MicroRomWins[i].Height==0
					|| MicroRomWins[i].Track==FALSE;
			winptr->Track=track;
			return((Win*)winptr);
		}
	return(0);
}

void DisplayMicroRomWin(MicroRomWin *winptr){
	int i;
	long int k;
	char c;
	boolean track;
	DumpFunPtr dumpfptr;
	dumpfptr=(winptr->DisplayMode==MBIN)?DumpBin:DumpHex;
	track=winptr->Track;
	Title("Microcode rom",track?"[T]":"[-]");
	k=(long)(track?PCTrack:winptr->StartAddr);
	winptr->EditOffset=k;
	for(i=0;i<winptr->Height;i++){
		if(k<MicroRomSize){
			printfi("%4.4X ",(int)k);
			k+=(*dumpfptr)(&MicroRom[k],MicroRomTop);
		}
		NextWinLine();
	}
}

int NotifyMicroRomWin(MicroRomWin *winptr,Event *evptr){
	unsigned long int addr,maxaddr;
	unsigned int linesize=16,height;
	int rc;
	boolean dirty;
	MemDisplayMode dmode;
	Event event0;
	dirty=winptr->Dirty;
	addr=(long)winptr->StartAddr;
	dmode=winptr->DisplayMode;
	if(dmode==MBIN) linesize=8;
	maxaddr=(long)(MicroRomSize-linesize);
	height=winptr->Height-1;
	switch(evptr->Type){
	case Cycle:
	case PCUpdate:
		dirty=winptr->Track && PhaseReg==0;
		break;
	case MicroRomUpdate:
		dirty=TRUE;
		break;
	case KeyPress:
		switch(evptr->Val){
		case ' ':
			winptr->DisplayMode=(dmode==MBIN)?MHEX:MBIN;
			addr&=(dmode==MBIN)?0xFFF0:0xFFF8;
			dirty=TRUE;
			break;
		case 'T':
		case 't':
			winptr->Track^=TRUE;
			dirty=TRUE;
			break;
		default:
			rc=VScroll(evptr->Val,&addr,maxaddr,linesize,height);
			if(rc>=0){
				dirty=rc;
			/*	CtlRomWin0->AutoTrack=FALSE; */
			}else{
				rc=EditMem(MicroRom,(long)(winptr->StartAddr),
					(long)MicroRomSize,evptr->Val,dmode,5);
				if( rc>0 ){
					dirty=TRUE;
					event0.Type=MicroRomUpdate;
					Broadcast(&event0);
					/* Le byte sur lequel pointe PC
					 * peut avoir chang, mais un opcode
					 * dj lu ne changera pas.
					 */
					CurX+=rc;
				}else{
					if( rc<0 ) return(FAIL);
				}
			}
		}
		winptr->StartAddr=(unsigned int)addr;
		break;
	default:
		return(FAIL);
	}
	winptr->Dirty=dirty;
	return(OK);
}

