/* 
 * Fichier:regs.c
 * Fentre sur les registres 'hardware' de MAYBE
 */

#include <stdio.h>
#include <stdlib.h>

#include "maysim.h"
#include "machine.h"
#include "display.h"
#include "maywin.h"
#include "hard.h"
#include "regs.h"

int NotifyRegWin(RegWin *,Event *);
void DisplayRegWin(RegWin *);

WinClass RegWinClass={
3,
3,
3,
(CreateFunPtr)CreateRegWin,
(DisplayFunPtr)DisplayRegWin,
(NotifyFunPtr)NotifyRegWin
};

RegWin RegWin0={&RegWinClass};

Win *CreateRegWin(){
	if( RegWin0.Height ) return(0);
	RegWin0.Height=RegWinClass.DefaultHeight;
	return((Win*)&RegWin0);
}

void DisplayRegWin(RegWin *RegWin0){
	Title("Hardware registers",0);
	printfi("A=0x%2.2X=%3.3u=%+4.3d=",AReg,AReg,AReg);PutBin((byte)AReg);
	printfi("B=0x%2.2X=%3.3u=%+4.3d=",BReg,BReg,BReg);PutBin((byte)BReg);
	printfi("ALU result:0x%2.2X=%3.3u=%+4.3d",ALUReg,ALUReg,ALUReg);
	NextWinLine();
	putsi("Cond Register:");
	putchari(CCode&64?' ':'~');putsi("Int ");
	putchari(CCode&32?'A':'~');putsi("P1 ");
	putchari(CCode&16?'B':'~');putsi("P0 ");
	putchari(CCode&8?' ':'~');putsi("D0 ");
	putchari(CCode&4?' ':'~');putsi("E ");
	putchari(CCode&2?'~':' ');putsi("C ");
	putchari(CCode?' ':'~');putsi("N ");
        putsi("Condition code register=");PutBin(CCodeReg);
        NextWinLine();
	printfi("OP=0x%2.2X Phase=0x%1X Reg.Addr=0x%2.2X->0x%2.2X PC=0x%4.4X",
		OpReg,PhaseReg,MAReg,SRam[MAReg],PCReg);
	putsi(" Switches=");PutBin(Switches);
	NextWinLine();
}

boolean CondMenu(){
	PutStatus("Toggle conditon code register: "
		  "[I]nt, P[0], P[1], [D]0, [E], [C], [N]");
	switch(tolower(GetKey())){
		case 'i':
			CCodeReg^=64;
			break;
		case '1':
			CCodeReg^=32;
			break;
		case '0':
			CCodeReg^=16;
			break;
		case 'd':
			CCodeReg^=8;
			break;
		case 'e':
			CCodeReg^=4;
			break;
		case 'c':
			CCodeReg^=2;
			break;
		case 'n':
			CCodeReg^=1;
			break;
		default:
			PutStatus(CancelStatus);
			return(FALSE);
	}
	return(TRUE);
}

int NotifyRegWin(RegWin *RegWin0,Event *Event0){
	unsigned long int i;
	boolean dirty=FALSE;
	switch(Event0->Type){
	case KeyPress:
		switch(tolower(Event0->Val)){
		case 'a':
			i=GetVal("A=");
			if( ErrFlag || i==AReg ) break;
			if( i<256 ){
				AReg=(byte)i;
				dirty=TRUE;
				Broadcast(&RegEvent);
			}else{
				Error(RangeErr);
			}
			break;
		case 'b':
			i=GetVal("B=");
			if( ErrFlag || i==BReg ) break;
			if( i<256 ){
				BReg=(byte)i;
				dirty=TRUE;
				Broadcast(&RegEvent);
			}else{
				Error(RangeErr);
			}
			break;
		case 'c':
			dirty=CondMenu();
			break;
		case 'o':
			i=GetVal("Opcode=");
			if( ErrFlag || i==OpReg ) break;
			if( i<256 ){
				OpReg=(byte)i;
				PhaseReg=0;
				dirty=TRUE;
				Broadcast(&OpcodeEvent);
			}else{
				Error(RangeErr);
			}
			break;
		case 'p':
			i=GetVal("Phase=");
			if( ErrFlag || i==PhaseReg ) break;
			if( i<16 ){
				PhaseReg=(byte)i;
				dirty=TRUE;
				Broadcast(&PhaseEvent);
			}else{
				Error(RangeErr);
			}
			break;
		case 'j':
			i=GetVal("Jump to?");
			if( ErrFlag || i==PCReg ) break;
			if( i<MicroRomSize ){
				Jump((word)i);
				dirty=TRUE;
				Broadcast(&PCEvent);
			}else{
				Error(RangeErr);
			}
			break;
		default:
			return(FAIL);
		}
		break;
	case Cycle:
	case RegUpdate:
	case PCUpdate:
	case OpcodeUpdate:
	case PhaseUpdate:
	case CtlRomUpdate: /* Peut changer le mot de contrle courant */
	case SRamUpdate: /* Peut changer le byte point par MAReg */
		dirty=TRUE;
		break;
	default:
		return(FAIL);
	}
	if( dirty ){
		/* UpdateALU(); */
		RegWin0->Dirty=TRUE;
	}
	return(OK);
}
