/*
 * Fichier:sram.c
 * Fentre sur la ram statique (registres) pour l'mulateur MAYBE
 */

#include <stdio.h>
#include "maysim.h"
#include "display.h"
#include "machine.h"
#include "maywin.h"
#include "memwin.h"
#include "hard.h"
#include "sram.h"

int NotifySRamWin(SRamWin *,Event *);
void DisplaySRamWin(SRamWin *);

WinClass SRamWinClass={
3,
1,
MAXUINT,
CreateSRamWin,
(DisplayFunPtr)DisplaySRamWin,
(NotifyFunPtr)NotifySRamWin
};

#define MaxSRamWins	MAXWINS
SRamWin SRamWins[MaxSRamWins];

Win *CreateSRamWin(){
	SRamWin * winptr;
	unsigned int i;
	for(i=0;i<MaxSRamWins;i++)
		if( SRamWins[i].Height==0 ){
			winptr=&SRamWins[i];
			InitMemWin((MemWin *)winptr,&SRamWinClass);
			winptr->TrackReg=-1;
			return((Win*)winptr);
		}
	return(0);
}

static char TrackMsg[]="[Track:0x??]";
void DisplaySRamWin(SRamWin *winptr){
	unsigned int i,k;
	int trackreg;
	DumpFunPtr dumpfptr;
	dumpfptr=(winptr->DisplayMode==MBIN)?DumpBin:DumpHex;
	trackreg=winptr->TrackReg;
	k=winptr->StartAddr;
	if( trackreg>=0 ){
		TrackMsg[9]=HexDigits[(trackreg>>4)&15];
		TrackMsg[10]=HexDigits[trackreg&15];
		k=SRam[trackreg];
	}
	winptr->EditOffset=k;
	Title("Register file (static ram)",trackreg<0?0:TrackMsg);
	for(i=0;i<winptr->Height;i++){
		if(k<SRamSize){
			printfi("%4.4X ",k);
			k+=(*dumpfptr)(&SRam[k],SRamTop);
		}
		NextWinLine();
	}	
}

int NotifySRamWin(SRamWin *winptr, Event *evptr){
	unsigned long int addr,maxaddr;
	unsigned int linesize=16,height,key;
	int rc;
	boolean dirty;
	byte tr;
	MemDisplayMode dmode;
	dirty=winptr->Dirty;
	addr=(long)winptr->StartAddr;
	dmode=winptr->DisplayMode;
	if(dmode==MBIN) linesize=8;
	maxaddr=(long)(SRamSize-linesize);
	height=winptr->Height-1;
	switch(evptr->Type){
	case Cycle:
	case SRamUpdate:
		dirty=TRUE;
		break;
	case KeyPress:
		switch(evptr->Val){
		case ' ':
			winptr->DisplayMode=(dmode==MBIN)?MHEX:MBIN;
			addr&=(dmode==MBIN)?0xFFF0:0xFFF8;
			dirty=TRUE;
			break;
		case 'T':
		case 't':
			if( winptr->TrackReg>=0 ){
				winptr->TrackReg=-1;
				dirty=TRUE;
			}else{
				tr=GetBVal("Track register?",MAReg);
				if( ErrFlag ) break;
				winptr->TrackReg=tr;
				dirty=TRUE;
			}
			break;
		default:
			key=evptr->Val;
			rc=VScroll(key,&addr,maxaddr,linesize,height);
			if(rc>=0){
				dirty=rc;
			/*	CtlRomWin0->AutoTrack=FALSE; */
/*			}else{ if( dmode==MHEX && key<0x7F
				   && (d=HexDigit(key))>=0 ){
				rc=EditHex(SRam,
					(long)(winptr->EditOffset),
					(long)SRamSize,
					CurX-5,	RelY()-1, d );
				if( rc ){
					dirty=TRUE;
					Broadcast(&SRamEvent);
					CurX+=rc;
				}
			}else{ if( dmode==MBIN && ( key=='0' || key=='1' ) ){
				rc=EditBin(SRam,
					(long)(winptr->EditOffset),
					(long)SRamSize,
					CurX-5,	RelY()-1, key-'0' );
				if( rc ){
					dirty=TRUE;
					Broadcast(&SRamEvent);
					CurX+=rc;
				}
			}else{
				return(FAIL);
			} } }
*/			}else{
				rc=EditMem(SRam,(long)(winptr->EditOffset),
					(long)SRamSize,key,dmode,5);
				if( rc>0 ){
					dirty=TRUE;
					Broadcast(&SRamEvent);
					CurX+=rc;
				}else{
					if( rc<0 ) return(FAIL);
				}
			}
		}
		winptr->StartAddr=(unsigned int)addr;
		break;
	default:
		return(FAIL);
	}
	winptr->Dirty=dirty;
	return(OK);
}
