/* 
 * Fichier:uart.c
 * Fentre sur les registres internes de l'UART 8250
 * Gestion de tampons extrieurs
 */

#include <stdio.h>
#include <string.h>
#include "maysim.h"
#include "machine.h"
#include "display.h"
#include "maywin.h"
#include "hard.h"
#include "uart.h"

int NotifyUartWin(UartWin *,Event *);
void DisplayUartWin(UartWin *);

WinClass UartWinClass={
4,
4,
4,
(CreateFunPtr)CreateUartWin,
(DisplayFunPtr)DisplayUartWin,
(NotifyFunPtr)NotifyUartWin
};

UartWin UartWin0={&UartWinClass};

Win *CreateUartWin(){
	if( UartWin0.Height==0 ){
		UartWin0.Height=UartWinClass.DefaultHeight;
		return((Win*)&UartWin0);
	}
	return(0);
}

static char *AddrNames[]={
	"@R/T","@IER","@IIR","@LCR","@MCR","@LSR","@MSR","????"
};

void DisplayUartWin(UartWin *winptr){
	int columns,i;
	char c;
	Title("8250 UART registers",0);
	printfi("RBR:0x%2.2X='%c' THR:0x%2.2X='%c' ",
	       RBR,(RBR>31&&RBR<128)?RBR:'.',
	       THR,(THR>31&&THR<128)?THR:'.' );
	putsi(AddrNames[AReg&7]);
	if(winptr->DisplayAll){
		printfi(" Divisor:%5.5u ",DivLatchLo+(DivLatchHi<<8));
		NextWinLine();
		putsi("IER:");PutBin(IER);
		putsi("IIR:");PutBin(IIR);
		putsi("LCR:");PutBin(LCR);
		putsi("MCR:");PutBin(MCR);
		putsi("LSR:");PutBin(LSR);
		putsi("MSR:");PutBin(MSR);
		NextWinLine();
		for( i=0; i<OutCol; i++ ){
			c=OutBuf[i];
			/* La ligne suivante cause un WARNING si le
			 * compilateur considre qu'un char a 7 bits.
			 * Ce n'est pas un problme.
			 */
			putchari((c>31 && c<128)?c:'.');
		}
		NextWinLine();
		NextWinLine();
	}else{
		if(!(IIR&1)) printfi("Pending interrupt #%u",IIR>>1);
		NextWinLine();
		putsi("LSR:");
		PutBit("TSRE",LSR&64);PutBit("THRE",LSR&32);
		PutBit("BI",LSR&16);PutBit("FE",LSR&8);PutBit("PE",LSR&4);
		PutBit("OR",LSR&2);PutBit("DR",LSR&1);
		putsi(" IER:");PutBit("ERBFI",IER&1);
		PutBit("ETBEI",IER&2);PutBit("ELSI",IER&4);
		PutBit("EDSSI",IER&8);
        	NextWinLine();
	        printfi("LCR:%u data bits, %s%s", /* Plus de %n */
        	       5+(LCR&3),
		       LCR&8?(LCR&32?(LCR&16?"trailing 0, ":"trailing 1, "):
				     (LCR&16?"even parity, ":"odd parity, "))
			    :"no parity, ",
		       LCR&4?(LCR&7==4?"1.5 stop bit ":"2 stop bits ")
			    :"1 stop bit "
			    /* , &columns */ );
		/* while( columns++<44) putchari(' '); */
		PutBit("Break",LCR&64);PutBit("DLAB",LCR&128);
		printfi("Divisor:%5.5u ",DivLatchLo+(DivLatchHi<<8));
		NextWinLine();
		putsi("MCR:");PutBit("Loop",MCR&16);
		PutBit("Out2",MCR&8);PutBit("Out1",MCR&4);
		PutBit("RTS",MCR&2);PutBit("DTR",MCR&1);
		putsi("       MSR:");
		PutBit(MSR&1?"CTS*":"CTS ",MSR&16);
		PutBit(MSR&2?"DSR*":"DSR ",MSR&32);
		PutBit(MSR&4?"RI*":"RI ",MSR&16);
		PutBit(MSR&1?"RLSD*":"RLSD ",MSR&16);
		NextWinLine();
	}
}

boolean SetRegMenu(){
	unsigned long int d;
	PutStatus("Set UART register: 0)RBR 1)IER 2)IIR 3)LCR"
		  " 4)MCR 5)LSR 6)MSR D)divisor latches");
	switch(GetKey()){
		case '0':
			RBR=GetBVal("Receive buffer register=",RBR);
			break;
		case '1':
			IER=GetBVal("Interrupt enable register=",IER);
			break;
		case '2':
			IIR=GetBVal("Interrupt id register=",IIR);
			break;
		case '3':
			LCR=GetBVal("Line control register=",LCR);
			break;
		case '4':
			MCR=GetBVal("Modem control register=",MCR);
			break;
		case '5':
			LSR=GetBVal("Line status register=",LSR);
			break;
		case '6':
			MSR=GetBVal("Modem status register=",MSR);
			break;
		case 'D':
		case 'd':
			d=DivLatchLo+(DivLatchHi<<8);
			d=GetDVal("Divisor latch (16 bits)=",
				  DivLatchLo+(DivLatchHi<<8));
			if(d>65535){
				Error(RangeErr);
			}else{
				DivLatchLo=d&255;
				DivLatchHi=(d>>8)&255;
			}
			break;
		default:
			PutStatus(CancelStatus);
			return(FALSE);
	}
	PutStatus(IdleStatus);
	return(TRUE);
}

int NotifyUartWin(UartWin *winptr,Event *evptr){
	unsigned int i;
	boolean dirty=FALSE;
	switch(evptr->Type){
	case KeyPress:
		switch(evptr->Val){
		case 'R':
		case 'r':
			PutStatus("Received character?");
			i=GetKey();
			PutStatus(IdleStatus);
			RBR=i;
			LSR|=1; /* Data Ready */
			dirty=TRUE;
			break;
		case 'S':
		case 's':
			dirty=SetRegMenu();
			break;
		case ' ':
			winptr->DisplayAll^=TRUE;
			dirty=TRUE;
			break;
		default:
			return(FAIL);
		}
		break;
	case Cycle:
/*	case UARTUpdate: */
		dirty=TRUE;
		break;
	default:
		return(FAIL);
	}
	winptr->Dirty=dirty;
	return(OK);
}

