/*----------------------------------------------------------------
 * This module is the physical interface between the program and
 * the hardware. The code is self-explanatory so that further
 * comments would not be necessary...
 *----------------------------------------------------------------
 */

#include "lp_io.h"
#ifndef __TURBOC__
#include <linux/ioport.h>
#include <linux/delay.h>
#include <sys/io.h>
#define inportb inb
#define outportb(a, d) outb(d, a)
#else
#include <dos.h>
#endif

unsigned short port = DEFAULT_PORT;
unsigned char extent = DEFAULT_EXTENT;

void lpWriteData(unsigned char data) {

  outportb(port, data);
}

unsigned char lpReadData() {

  return inportb(port);
}

void lpWriteCommand(unsigned char data) {

  outportb(port + 2, data);
}

unsigned char lpReadCommand() {

  return inportb(port + 2);
}

unsigned char lpReadStatus() {

  return inportb(port + 1);
}

int lpSelectPort(unsigned short p, unsigned char e) {

  port = p;
  extent = e;
#ifndef __TURBOC__
  return ioperm(p, e, 1);
#endif
  return 0;
}

int lpReleasePort() {
  int r = 0;

#ifndef __TURBOC__
  r = ioperm(port, extent, 0);
#endif

  port = DEFAULT_PORT;
  return r;
}
