#include <stdlib.h>
#include "capteur.h"
#include <sys/types.h> /* fork */
#include <unistd.h> /* fork */
#include <errno.h>
#include <stdio.h>

int main(int argc, char **argv) {
  int i, j[8]={1, 2, 3, 4, 5, 6, 7, 8}, k = 0;
  pid_t pid;
  int not_done = 1;

  if(cap_init() == -1) exit(-1);
  pid = fork();
  switch(pid) {

  case -1:
    perror("fork");
    exit(-1);

  case 0:
    i = 0;
    while(not_done) {
      cap_select_camera(i? (i=0) : (i=1));
      k++;
      if (k == 8) not_done--;
      sleep(1);
    }
    break;

  default:
    while(not_done) {
      cap_led_on(j[k]);
      sleep(2);
      cap_led_off(j[k++]);
      if (k == 8) not_done--;
    }
    break;
  }

  if (cap_close() == -1) {
    perror("cap_close()");
    exit(-1);
  }
  return 0;
}
