#ifndef PPI_IO_H
#define PPI_IO_H

#include "lp_io.h"

#define PPI_MAX 3
#define AUTO_PROBE 3
#define LP0 0
#define LP1 1
#define LP2 2
#define PORT_A 0
#define PORT_B 1
#define PORT_C 2
#define CONTROL_WORD 3

typedef struct {
	int base;
	int extent;
	int selected;
} ppi_struct;

void ppiWrite(unsigned short ppi_port, unsigned char value);
unsigned char ppiRead(unsigned short ppi_port);
int ppiOpen(int num);
int ppiClose(void);

#endif

