analysis <- as.character(commandArgs(TRUE))

library(GenABEL)
library(kinship)

print(analysis)
spy=read.table(paste(analysis,".ped",sep=""))
pedigree = read.table(paste(analysis,".ped",sep=""),colClasses=c(rep("numeric",6),rep("character",ncol(spy)-6)))
phenoGenABEL = pedigree[,c(2,5,6)]
phenoGenABEL[,2] = 2-phenoGenABEL[,2]
write.table(t(c("id","sex","trait")),paste(analysis,"_GenABEL.phe",sep=""),row.names=FALSE,col.names=FALSE,quote=FALSE)
write.table(phenoGenABEL,paste(analysis,"_GenABEL.phe",sep=""),row.names=FALSE,col.names=FALSE,quote=FALSE,append=TRUE)
pedigree[,6] = 0
write.table(pedigree,file=paste(analysis,"_GenABEL.ped",sep=""),row.names=FALSE,col.names=FALSE,quote=FALSE)

convert.snp.ped(paste(analysis,".ped",sep=""), paste(analysis,".map",sep=""), paste(analysis,"_GenABEL.raw",sep=""))
simulation.GenABEL = load.gwaa.data(phenofile = paste(analysis,"_GenABEL.phe",sep=""), genofile = paste(analysis,"_GenABEL.raw",sep=""), force=F,makemap=F,sort=F)

pkin = kinship(pedigree[,2],pedigree[,3],pedigree[,4])
Yfit = polygenic(trait,pkin,simulation.GenABEL,trait.type="gaussian")
resi = Yfit$pgresidualY

pedigree[,6] = resi
pedigree[,c(1,3,4)]=0
write.table(pedigree,paste(analysis,"_MBMDR.ped",sep=""),row.names=FALSE,col.names=FALSE, quote=FALSE)