/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __AXIS_ALIGNED_BOUNDING_BOX_H__
#define __AXIS_ALIGNED_BOUNDING_BOX_H__

#include <ostream>

class AxisAlignedBoundingBox {

private :

	int minX ;
	int maxX ;
	int minY ;
	int maxY ;

	friend std :: ostream & operator << ( std :: ostream & s , const AxisAlignedBoundingBox & aabb ) {
		return s << "Axis Aligned Bounding Box [ " << aabb.minX << " , " << aabb.maxX << " ] x [ " << aabb.minY << " , " << aabb.maxY << " ]" ;
	}

public :

	AxisAlignedBoundingBox () ;
	AxisAlignedBoundingBox ( int minX , int maxX , int minY , int maxY ) ;

	bool isEmpty () const ;

	int getMinX () const ;
	int getMaxX () const ;
	int getMinY () const ;
	int getMaxY () const ;

	void extendToIncludePoint ( int x , int y ) ;
	void extendToIncludeAABB ( const AxisAlignedBoundingBox & aabb ) ;

	static bool equals ( const AxisAlignedBoundingBox & aabb1 , const AxisAlignedBoundingBox & aabb2 ) ;

	virtual ~ AxisAlignedBoundingBox () ;

} ;

#endif
