/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __GRAYSCALE_IMAGE_H__
#define __GRAYSCALE_IMAGE_H__

#include <stdexcept>

class GrayscaleImage {

private:

	unsigned int width ;
	unsigned int height ;
	unsigned int stride ;
	unsigned char * pixels ;

public :

	GrayscaleImage ( unsigned int width , unsigned int height ) ;
	GrayscaleImage ( const char * path ) ;

	inline unsigned int getWidth () const {
		return width ;
	}

	inline unsigned int getHeight () const {
		return height ;
	}

	inline unsigned char getPixel ( unsigned int row , unsigned int col ) const {
		if ( row >= height ) throw std::out_of_range ( "row >= height" ) ;
		if ( col >= width ) throw std::out_of_range ( "col >= width" ) ;
		return pixels [ row * stride + col ] ;
	}

	inline void getPixel ( unsigned int row , unsigned int col , unsigned char val ) {
		if ( row >= height ) throw std::out_of_range ( "row >= height" ) ;
		if ( col >= width ) throw std::out_of_range ( "col >= width" ) ;
		pixels [ row * stride + col ] = val ;
	}

	void saveAsPGM ( const char * path ) ;
	void saveAsJPG ( const char * path , int quality ) ;

	~ GrayscaleImage () ;

} ;

#endif

