/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __DEFAULT_VOLUME_2D_H__
#define __DEFAULT_VOLUME_2D_H__

#include "AxisAlignedBoundingBox.h"
#include "Matrix.h"
#include "Volume2D.h"

class DefaultVolume2D : public Volume2D {

private :

	const int minX ;
	const int maxX ;
	const int minY ;
	const int maxY ;
	Matrix < bool > * mat ;
	int area ;

public:

	DefaultVolume2D ( int minX , int maxX , int minY , int maxY ) ;
	bool isPointInside ( int x , int y ) const ;
	AxisAlignedBoundingBox getBoundingBox () const ;
	void add ( const Volume2D & other ) ;
	int getArea () const ;
	virtual ~ DefaultVolume2D () ;

} ;

#endif
