/**
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright 2009, 2010, 2011 Sébastien PIERARD
 */

#ifndef __MATRIX_H__
#define __MATRIX_H__

#include <stdexcept>
#include <stdlib.h> // malloc, free

template < class T > class Matrix {

private :

	int minI ;
	int maxI ;
	int minJ ;
	int maxJ ;
	T * * data ;

public :

	T & operator () ( int i , int j ) ;

	Matrix ( int minI , int maxI , int minJ , int maxJ ) ;
	~ Matrix () ;

} ;

template < class T > T & Matrix < T > :: operator () ( int i , int j ) {
	if ( i < minI || i > maxI ) throw std::out_of_range ( "index out of range" ) ;
	if ( j < minJ || j > maxJ ) throw std::out_of_range ( "index out of range" ) ;
	return data [ i - minI ] [ j - minJ ] ;
}

template < class T > static T * * malloc2D ( int rows , int cols ) {
	T * * ptr = ( T * * ) malloc ( sizeof ( T * ) * rows + sizeof ( T ) * cols * rows ) ;
	if ( ptr == NULL ) throw std::bad_alloc () ;
	T * dat = ( T * ) ( ptr + rows ) ;
	for ( int i = 0 ; i < rows ; ++ i , dat += cols ) ptr [ i ] = dat ;
	return ptr ;
}

template < class T > Matrix < T > :: Matrix ( int minI , int maxI , int minJ , int maxJ ) {
	if ( maxI < minI ) throw std::invalid_argument ( "max < min for i" ) ;
	if ( maxJ < minJ ) throw std::invalid_argument ( "max < min for j" ) ;
	this -> minI = minI ;
	this -> maxI = maxI ;
	this -> minJ = minJ ;
	this -> maxJ = maxJ ;
	this -> data = malloc2D < T > ( maxI - minI + 1 , maxJ - minJ + 1 ) ;
}

template < class T > Matrix < T > :: ~ Matrix < T > () {
	free ( data ) ;
}

#endif
